/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.net;

import io.atomix.utils.net.MalformedAddressException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public final class Address {
    private static final int DEFAULT_PORT = 5679;
    private final String host;
    private final int port;
    private volatile transient Type type;
    private volatile InetSocketAddress socketAddress;

    public Address(String host, int port) {
        this(host, port, null);
    }

    public Address(String host, int port, InetAddress address) {
        this.host = host;
        this.port = port;
        if (address != null) {
            this.type = address instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
            this.socketAddress = new InetSocketAddress(address, port);
        } else {
            this.socketAddress = new InetSocketAddress(host, port);
        }
    }

    public static Address local() {
        return Address.from(5679);
    }

    public static Address from(String address) {
        int port;
        int lastColon = address.lastIndexOf(58);
        int openBracket = address.indexOf(91);
        int closeBracket = address.indexOf(93);
        String host = openBracket != -1 && closeBracket != -1 ? address.substring(openBracket + 1, closeBracket) : (lastColon != -1 ? address.substring(0, lastColon) : address);
        if (lastColon != -1) {
            try {
                port = Integer.parseInt(address.substring(lastColon + 1));
            }
            catch (NumberFormatException e) {
                throw new MalformedAddressException(address, e);
            }
        } else {
            port = 5679;
        }
        return new Address(host, port);
    }

    public static Address from(String host, int port) {
        return new Address(host, port);
    }

    public static Address from(int port) {
        try {
            InetAddress address = Address.getLocalAddress();
            return new Address(address.getHostName(), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to locate host", e);
        }
    }

    private static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ignore) {
            return InetAddress.getByName(null);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public InetAddress address() {
        return this.address(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress address(boolean resolve) {
        if (resolve) {
            this.socketAddress = this.resolveAddress();
            return this.socketAddress.getAddress();
        }
        if (this.socketAddress.isUnresolved()) {
            Address address = this;
            synchronized (address) {
                if (this.socketAddress.isUnresolved()) {
                    this.socketAddress = this.resolveAddress();
                }
            }
        }
        return this.socketAddress.getAddress();
    }

    public InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    private InetSocketAddress resolveAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.host), this.port);
        }
        catch (UnknownHostException e) {
            if (this.socketAddress.isUnresolved()) {
                return this.socketAddress;
            }
            return new InetSocketAddress(this.host, this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type type() {
        if (this.type == null) {
            Address address = this;
            synchronized (address) {
                if (this.type == null) {
                    this.type = this.address() instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
                }
            }
        }
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)obj;
        return this.host.equals(that.host) && this.port == that.port;
    }

    public String toString() {
        String host = this.host();
        int port = this.port();
        if (host.matches("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}")) {
            return String.format("[%s]:%d", host, port);
        }
        return String.format("%s:%d", host, port);
    }

    public static enum Type {
        IPV4,
        IPV6;

    }
}

