/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.time;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import io.atomix.utils.time.Timestamp;
import io.atomix.utils.time.Version;
import java.util.Objects;

public class LogicalTimestamp
implements Timestamp {
    private final long value;

    public LogicalTimestamp(long value) {
        this.value = value;
    }

    public static LogicalTimestamp of(long value) {
        return new LogicalTimestamp(value);
    }

    public long value() {
        return this.value;
    }

    public Version asVersion() {
        return new Version(this.value);
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof LogicalTimestamp), (String)"Must be LogicalTimestamp", (Object)o);
        LogicalTimestamp that = (LogicalTimestamp)o;
        return ComparisonChain.start().compare(this.value, that.value).result();
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogicalTimestamp)) {
            return false;
        }
        LogicalTimestamp that = (LogicalTimestamp)obj;
        return Objects.equals(this.value, that.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).toString();
    }
}

