/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.time;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import io.atomix.utils.Identifier;
import io.atomix.utils.time.LogicalTimestamp;
import io.atomix.utils.time.Timestamp;
import java.util.Objects;

public class VectorTimestamp<T extends Identifier>
extends LogicalTimestamp {
    private final T identifier;

    public VectorTimestamp(T identifier, long value) {
        super(value);
        this.identifier = identifier;
    }

    public T identifier() {
        return this.identifier;
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof VectorTimestamp), (String)"Must be VectorTimestamp", (Object)o);
        VectorTimestamp that = (VectorTimestamp)o;
        return ComparisonChain.start().compare(this.identifier.id(), that.identifier.id()).compare(this.value(), that.value()).result();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identifier(), this.value());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VectorTimestamp) {
            VectorTimestamp that = (VectorTimestamp)obj;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.value(), that.value());
        }
        if (obj instanceof LogicalTimestamp) {
            return obj.equals(this);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", this.identifier()).add("value", this.value()).toString();
    }
}

