/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker;

import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.broker.system.configuration.SocketBindingCfg;
import io.zeebe.util.exception.UncheckedExecutionException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.stereotype.Component;

@Component
public class BrokerSpringServerCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @Autowired
    BrokerCfg brokerCfg;

    public void customize(ConfigurableServletWebServerFactory server) {
        NetworkCfg networkCfg = this.brokerCfg.getNetwork();
        networkCfg.applyDefaults();
        SocketBindingCfg monitoringApiCfg = networkCfg.getMonitoringApi();
        try {
            server.setAddress(InetAddress.getByName(monitoringApiCfg.getHost()));
        }
        catch (UnknownHostException e) {
            throw new UncheckedExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        server.setPort(monitoringApiCfg.getPort());
    }
}

