/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.gateway.impl.configuration.MonitoringCfg;
import io.zeebe.util.exception.UncheckedExecutionException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.stereotype.Component;

@Component
public class GatewaySpringServerCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    @Autowired
    GatewayCfg gatewayCfg;

    public void customize(ConfigurableServletWebServerFactory server) {
        if (!this.gatewayCfg.isInitialized()) {
            this.gatewayCfg.init();
        }
        MonitoringCfg monitoringApiCfg = this.gatewayCfg.getMonitoring();
        try {
            server.setAddress(InetAddress.getByName(monitoringApiCfg.getHost()));
        }
        catch (UnknownHostException e) {
            throw new UncheckedExecutionException(e.getLocalizedMessage(), (Throwable)e);
        }
        server.setPort(monitoringApiCfg.getPort());
    }
}

