/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.FileBytes;
import io.atomix.storage.buffer.MappedBuffer;
import io.atomix.utils.memory.Memory;
import java.io.File;
import java.nio.channels.FileChannel;

public final class FileBuffer
extends AbstractBuffer {
    private final FileBytes bytes;

    private FileBuffer(FileBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.bytes = bytes;
    }

    public static FileBuffer allocate(File file) {
        return FileBuffer.allocate(file, "rw", 4096, Integer.MAX_VALUE);
    }

    public static FileBuffer allocate(File file, int initialCapacity) {
        return FileBuffer.allocate(file, "rw", initialCapacity, Integer.MAX_VALUE);
    }

    public static FileBuffer allocate(File file, int initialCapacity, int maxCapacity) {
        return FileBuffer.allocate(file, "rw", initialCapacity, maxCapacity);
    }

    public static FileBuffer allocate(File file, String mode, int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new FileBuffer(new FileBytes(file, mode, (int)Math.min(Memory.Util.toPow2((int)initialCapacity), (long)maxCapacity)), 0, initialCapacity, maxCapacity);
    }

    public File file() {
        return this.bytes.file();
    }

    public MappedBuffer map(int size) {
        return this.map(this.position(), size, FileChannel.MapMode.READ_WRITE);
    }

    public MappedBuffer map(int size, FileChannel.MapMode mode) {
        return this.map(this.position(), size, mode);
    }

    public MappedBuffer map(int offset, int size) {
        return this.map(offset, size, FileChannel.MapMode.READ_WRITE);
    }

    public MappedBuffer map(int offset, int size, FileChannel.MapMode mode) {
        return new MappedBuffer(this.bytes.map(offset, size, mode), 0, size, size);
    }

    @Override
    protected void compact(int from, int to, int length) {
        int size;
        byte[] bytes = new byte[1024];
        for (int position = from; position < from + length; position += size) {
            size = Math.min(from + length - position, 1024);
            this.bytes.read(position, bytes, 0, size);
            this.bytes.write(0, bytes, 0, size);
        }
    }

    @Override
    public FileBuffer duplicate() {
        return new FileBuffer(new FileBytes(this.bytes.file(), this.bytes.mode(), this.bytes.size()), this.offset(), this.capacity(), this.maxCapacity());
    }

    public FileBuffer duplicate(String mode) {
        return new FileBuffer(new FileBytes(this.bytes.file(), mode, this.bytes.size()), this.offset(), this.capacity(), this.maxCapacity());
    }

    public void delete() {
        this.bytes.delete();
    }
}

