/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.ByteBufferBuffer;
import io.atomix.storage.buffer.MappedBytes;
import java.io.File;
import java.nio.channels.FileChannel;

public class MappedBuffer
extends ByteBufferBuffer {
    protected MappedBuffer(MappedBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }

    public static MappedBuffer allocate(File file) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, 4096, Integer.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode) {
        return MappedBuffer.allocate(file, mode, 4096, Integer.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, int capacity) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, int capacity) {
        return MappedBuffer.allocate(file, mode, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, int initialCapacity, int maxCapacity) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, initialCapacity, maxCapacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, int initialCapacity, int maxCapacity) {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        Preconditions.checkNotNull((Object)mode, (Object)"mode cannot be null");
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new MappedBuffer(MappedBytes.allocate(file, mode, initialCapacity), 0, initialCapacity, maxCapacity);
    }

    @Override
    public MappedBuffer duplicate() {
        return new MappedBuffer((MappedBytes)this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }

    public void delete() {
        ((MappedBytes)this.bytes).delete();
    }
}

