/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.Bytes;

public class SlicedBuffer
extends AbstractBuffer {
    private final Buffer root;

    public SlicedBuffer(Buffer root, Bytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.root = root;
        root.acquire();
    }

    public Buffer root() {
        return this.root;
    }

    @Override
    public Buffer duplicate() {
        return new SlicedBuffer(this.root, this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }

    @Override
    public Buffer acquire() {
        this.root.acquire();
        return this;
    }

    @Override
    public boolean release() {
        return this.root.release();
    }

    @Override
    public boolean isDirect() {
        return this.root.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.root.isReadOnly();
    }

    @Override
    public boolean isFile() {
        return this.root.isFile();
    }

    @Override
    public void close() {
        this.root.release();
    }

    @Override
    public Buffer compact() {
        return null;
    }

    @Override
    protected void compact(int from, int to, int length) {
        if (this.root instanceof AbstractBuffer) {
            ((AbstractBuffer)this.root).compact(from, to, length);
        }
    }
}

