/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.Bytes;
import io.atomix.utils.concurrent.ReferenceManager;
import java.nio.ByteOrder;

public class SwappedBuffer
extends AbstractBuffer {
    private final Buffer root;

    SwappedBuffer(Buffer root, Bytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.root = root;
    }

    public SwappedBuffer(Buffer buffer, int offset, int initialCapacity, int maxCapacity, ReferenceManager<Buffer> referenceManager) {
        super(buffer.bytes().order(buffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN), offset, initialCapacity, maxCapacity, referenceManager);
        this.root = buffer instanceof SwappedBuffer ? ((SwappedBuffer)buffer).root : buffer;
        this.root.acquire();
    }

    public Buffer root() {
        return this.root;
    }

    @Override
    public Buffer duplicate() {
        return new SwappedBuffer(this.root, this.offset(), this.capacity(), this.maxCapacity(), (ReferenceManager<Buffer>)this.referenceManager);
    }

    @Override
    public Buffer acquire() {
        this.root.acquire();
        return this;
    }

    @Override
    public boolean release() {
        return this.root.release();
    }

    @Override
    public boolean isDirect() {
        return this.root.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.root.isReadOnly();
    }

    @Override
    public boolean isFile() {
        return this.root.isFile();
    }

    @Override
    public void close() {
        this.root.release();
    }

    @Override
    protected void compact(int from, int to, int length) {
        if (this.root instanceof AbstractBuffer) {
            ((AbstractBuffer)this.root).compact(from, to, length);
        }
    }
}

