/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.WrappedBytes;
import java.nio.ByteOrder;

public class SwappedBytes
extends WrappedBytes {
    public SwappedBytes(Bytes bytes) {
        super(bytes);
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public int readUnsignedShort(int offset) {
        return Short.reverseBytes(this.bytes.readShort(offset)) & 0xFFFF;
    }

    @Override
    public int readMedium(int offset) {
        return Integer.reverseBytes(this.bytes.readMedium(offset));
    }

    @Override
    public int readUnsignedMedium(int offset) {
        return Integer.reverseBytes(this.bytes.readUnsignedMedium(offset));
    }

    @Override
    public long readUnsignedInt(int offset) {
        return (long)Integer.reverseBytes(this.bytes.readInt(offset)) & 0xFFFFFFFFL;
    }

    @Override
    public Bytes writeUnsignedShort(int offset, int s) {
        this.bytes.writeUnsignedShort(offset, Short.reverseBytes((short)s));
        return this;
    }

    @Override
    public Bytes writeMedium(int offset, int m) {
        this.bytes.writeMedium(offset, Integer.reverseBytes(m));
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(int offset, int m) {
        this.bytes.writeUnsignedMedium(offset, Integer.reverseBytes(m));
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(int offset, long i) {
        this.bytes.writeUnsignedInt(offset, Integer.reverseBytes((int)i));
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.bytes.writeChar(offset, Character.reverseBytes(c));
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.bytes.writeShort(offset, Short.reverseBytes(s));
        return this;
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.bytes.writeInt(offset, Integer.reverseBytes(i));
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.bytes.writeLong(offset, Long.reverseBytes(l));
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        return this.writeInt(offset, Float.floatToRawIntBits(f));
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        return this.writeLong(offset, Double.doubleToRawLongBits(d));
    }

    @Override
    public char readChar(int offset) {
        return Character.reverseBytes(this.bytes.readChar(offset));
    }

    @Override
    public short readShort(int offset) {
        return Short.reverseBytes(this.bytes.readShort(offset));
    }

    @Override
    public int readInt(int offset) {
        return Integer.reverseBytes(this.bytes.readInt(offset));
    }

    @Override
    public long readLong(int offset) {
        return Long.reverseBytes(this.bytes.readLong(offset));
    }

    @Override
    public float readFloat(int offset) {
        return Float.intBitsToFloat(this.readInt(offset));
    }

    @Override
    public double readDouble(int offset) {
        return Double.longBitsToDouble(this.readLong(offset));
    }
}

