/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBytes;
import io.atomix.storage.buffer.Bytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WrappedBytes
extends AbstractBytes {
    protected final Bytes bytes;
    private final Bytes root;

    public WrappedBytes(Bytes bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        this.bytes = bytes;
        this.root = bytes instanceof WrappedBytes ? ((WrappedBytes)bytes).root : bytes;
    }

    public Bytes root() {
        return this.root;
    }

    @Override
    public int size() {
        return this.bytes.size();
    }

    @Override
    public Bytes resize(int newSize) {
        return this.bytes.resize(newSize);
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order();
    }

    @Override
    public void close() {
        this.bytes.close();
    }

    @Override
    public int readUnsignedByte(int offset) {
        return this.bytes.readUnsignedByte(offset);
    }

    @Override
    public int readUnsignedShort(int offset) {
        return this.bytes.readUnsignedShort(offset);
    }

    @Override
    public int readMedium(int offset) {
        return this.bytes.readMedium(offset);
    }

    @Override
    public int readUnsignedMedium(int offset) {
        return this.bytes.readUnsignedMedium(offset);
    }

    @Override
    public long readUnsignedInt(int offset) {
        return this.bytes.readUnsignedInt(offset);
    }

    @Override
    public boolean readBoolean(int offset) {
        return this.bytes.readBoolean(offset);
    }

    @Override
    public String readString(int offset) {
        return this.bytes.readString(offset);
    }

    @Override
    public String readUTF8(int offset) {
        return this.bytes.readUTF8(offset);
    }

    @Override
    public Bytes writeUnsignedByte(int offset, int b) {
        this.bytes.writeUnsignedByte(offset, b);
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(int offset, int s) {
        this.bytes.writeUnsignedShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeMedium(int offset, int m) {
        this.bytes.writeMedium(offset, m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(int offset, int m) {
        this.bytes.writeUnsignedMedium(offset, m);
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(int offset, long i) {
        this.bytes.writeUnsignedInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeBoolean(int offset, boolean b) {
        this.bytes.writeBoolean(offset, b);
        return this;
    }

    @Override
    public Bytes writeString(int offset, String s) {
        this.bytes.writeString(offset, s);
        return this;
    }

    @Override
    public Bytes writeUTF8(int offset, String s) {
        this.bytes.writeUTF8(offset, s);
        return this;
    }

    @Override
    public Bytes flush() {
        this.bytes.flush();
        return this;
    }

    @Override
    public Bytes zero() {
        this.bytes.zero();
        return this;
    }

    @Override
    public Bytes zero(int offset) {
        this.bytes.zero(offset);
        return this;
    }

    @Override
    public Bytes zero(int offset, int length) {
        this.bytes.zero(offset, length);
        return this;
    }

    @Override
    public Bytes write(int offset, Bytes src, int srcOffset, int length) {
        this.bytes.write(offset, src, srcOffset, length);
        return this;
    }

    @Override
    public Bytes write(int offset, byte[] src, int srcOffset, int length) {
        this.bytes.write(offset, src, srcOffset, length);
        return this;
    }

    @Override
    public Bytes write(int offset, ByteBuffer src, int srcOffset, int length) {
        this.bytes.write(offset, src, srcOffset, length);
        return this;
    }

    @Override
    public Bytes writeByte(int offset, int b) {
        this.bytes.writeByte(offset, b);
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.bytes.writeChar(offset, c);
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.bytes.writeShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.bytes.writeInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.bytes.writeLong(offset, l);
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        this.bytes.writeFloat(offset, f);
        return this;
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        this.bytes.writeDouble(offset, d);
        return this;
    }

    @Override
    public Bytes read(int offset, Bytes dst, int dstOffset, int length) {
        this.bytes.read(offset, dst, dstOffset, length);
        return this;
    }

    @Override
    public Bytes read(int offset, byte[] dst, int dstOffset, int length) {
        this.bytes.read(offset, dst, dstOffset, length);
        return this;
    }

    @Override
    public Bytes read(int offset, ByteBuffer dst, int dstOffset, int length) {
        this.bytes.read(offset, dst, dstOffset, length);
        return this;
    }

    @Override
    public int readByte(int offset) {
        return this.bytes.readByte(offset);
    }

    @Override
    public char readChar(int offset) {
        return this.bytes.readChar(offset);
    }

    @Override
    public short readShort(int offset) {
        return this.bytes.readShort(offset);
    }

    @Override
    public int readInt(int offset) {
        return this.bytes.readInt(offset);
    }

    @Override
    public long readLong(int offset) {
        return this.bytes.readLong(offset);
    }

    @Override
    public float readFloat(int offset) {
        return this.bytes.readFloat(offset);
    }

    @Override
    public double readDouble(int offset) {
        return this.bytes.readDouble(offset);
    }
}

