/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.value;

import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import java.util.Objects;

public final class LongValue
extends BaseValue {
    private long value;

    public LongValue() {
        this(0L);
    }

    public LongValue(long initialValue) {
        this.value = initialValue;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long val) {
        this.value = val;
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append(this.value);
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeInteger(this.value);
    }

    @Override
    public void read(MsgPackReader reader) {
        this.value = reader.readInteger();
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedLongValueLength((long)this.value);
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongValue)) {
            return false;
        }
        LongValue longValue = (LongValue)o;
        return this.getValue() == longValue.getValue();
    }
}

