/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import io.zeebe.snapshots.broker.impl.FileBasedSnapshotChunkReader;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotMetadata;
import io.zeebe.snapshots.broker.impl.SnapshotChecksum;
import io.zeebe.snapshots.raft.PersistedSnapshot;
import io.zeebe.snapshots.raft.SnapshotChunkReader;
import io.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedSnapshot
implements PersistedSnapshot {
    private static final int VERSION = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedSnapshot.class);
    private final Path directory;
    private final FileBasedSnapshotMetadata metadata;

    FileBasedSnapshot(Path directory, FileBasedSnapshotMetadata metadata) {
        this.directory = directory;
        this.metadata = metadata;
    }

    public FileBasedSnapshotMetadata getMetadata() {
        return this.metadata;
    }

    public Path getDirectory() {
        return this.directory;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public long getIndex() {
        return this.metadata.getIndex();
    }

    @Override
    public long getTerm() {
        return this.metadata.getTerm();
    }

    @Override
    public SnapshotChunkReader newChunkReader() {
        try {
            return new FileBasedSnapshotChunkReader(this.directory, SnapshotChecksum.read(this.directory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void delete() {
        if (!Files.exists(this.directory, new LinkOption[0])) {
            return;
        }
        try {
            FileUtil.deleteFolder((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete snapshot {}", (Object)this, (Object)e);
        }
    }

    @Override
    public Path getPath() {
        return this.getDirectory();
    }

    @Override
    public long getCompactionBound() {
        return this.getIndex();
    }

    @Override
    public String getId() {
        return this.metadata.getSnapshotIdAsString();
    }

    public void close() {
    }

    public int hashCode() {
        return Objects.hash(this.getDirectory(), this.getMetadata());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedSnapshot that = (FileBasedSnapshot)o;
        return this.getDirectory().equals(that.getDirectory()) && this.getMetadata().equals(that.getMetadata());
    }

    public String toString() {
        return "FileBasedSnapshot{directory=" + this.directory + ", metadata=" + this.metadata + "}";
    }
}

