/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import io.zeebe.snapshots.broker.ConstructableSnapshotStore;
import io.zeebe.snapshots.broker.SnapshotStoreSupplier;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotStore;
import io.zeebe.snapshots.broker.impl.SnapshotMetrics;
import io.zeebe.snapshots.raft.PersistedSnapshotStore;
import io.zeebe.snapshots.raft.ReceivableSnapshotStore;
import io.zeebe.snapshots.raft.ReceivableSnapshotStoreFactory;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.SchedulingHints;
import java.io.File;
import java.nio.file.Path;
import org.agrona.IoUtil;
import org.agrona.collections.Int2ObjectHashMap;

public final class FileBasedSnapshotStoreFactory
implements SnapshotStoreSupplier,
ReceivableSnapshotStoreFactory {
    public static final String SNAPSHOTS_DIRECTORY = "snapshots";
    public static final String PENDING_DIRECTORY = "pending";
    private final Int2ObjectHashMap<FileBasedSnapshotStore> partitionSnapshotStores = new Int2ObjectHashMap();
    private final ActorScheduler actorScheduler;
    private final int nodeId;

    public FileBasedSnapshotStoreFactory(ActorScheduler actorScheduler, int nodeId) {
        this.actorScheduler = actorScheduler;
        this.nodeId = nodeId;
    }

    @Override
    public ReceivableSnapshotStore createReceivableSnapshotStore(Path root, int partitionId) {
        Path snapshotDirectory = root.resolve(SNAPSHOTS_DIRECTORY);
        Path pendingDirectory = root.resolve(PENDING_DIRECTORY);
        IoUtil.ensureDirectoryExists((File)snapshotDirectory.toFile(), (String)"Snapshot directory");
        IoUtil.ensureDirectoryExists((File)pendingDirectory.toFile(), (String)"Pending snapshot directory");
        return (ReceivableSnapshotStore)this.partitionSnapshotStores.computeIfAbsent(partitionId, p -> this.createAndOpenNewSnapshotStore(partitionId, snapshotDirectory, pendingDirectory));
    }

    private FileBasedSnapshotStore createAndOpenNewSnapshotStore(int partitionId, Path snapshotDirectory, Path pendingDirectory) {
        FileBasedSnapshotStore snapshotStore = new FileBasedSnapshotStore(this.nodeId, partitionId, new SnapshotMetrics(Integer.toString(partitionId)), snapshotDirectory, pendingDirectory);
        this.actorScheduler.submitActor((Actor)snapshotStore, SchedulingHints.ioBound()).join();
        return snapshotStore;
    }

    @Override
    public ConstructableSnapshotStore getConstructableSnapshotStore(int partitionId) {
        return (ConstructableSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }

    @Override
    public ReceivableSnapshotStore getReceivableSnapshotStore(int partitionId) {
        return (ReceivableSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }

    @Override
    public PersistedSnapshotStore getPersistedSnapshotStore(int partitionId) {
        return (PersistedSnapshotStore)this.partitionSnapshotStores.get(partitionId);
    }
}

