/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import io.prometheus.client.Histogram;
import io.zeebe.snapshots.broker.SnapshotId;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotMetadata;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotStore;
import io.zeebe.snapshots.broker.impl.SnapshotChecksum;
import io.zeebe.snapshots.broker.impl.SnapshotMetrics;
import io.zeebe.snapshots.raft.PersistedSnapshot;
import io.zeebe.snapshots.raft.TransientSnapshot;
import io.zeebe.util.FileUtil;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedTransientSnapshot
implements TransientSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedTransientSnapshot.class);
    private final Path directory;
    private final ActorControl actor;
    private final FileBasedSnapshotStore snapshotStore;
    private final FileBasedSnapshotMetadata metadata;
    private final ActorFuture<Boolean> takenFuture = new CompletableActorFuture();
    private boolean isValid = false;
    private PersistedSnapshot snapshot;

    FileBasedTransientSnapshot(FileBasedSnapshotMetadata metadata, Path directory, FileBasedSnapshotStore snapshotStore, ActorControl actor) {
        this.metadata = metadata;
        this.snapshotStore = snapshotStore;
        this.directory = directory;
        this.actor = actor;
    }

    @Override
    public ActorFuture<Boolean> take(Predicate<Path> takeSnapshot) {
        this.actor.run(() -> this.takeInternal(takeSnapshot));
        return this.takenFuture;
    }

    @Override
    public void onSnapshotTaken(BiConsumer<Boolean, Throwable> runnable) {
        this.actor.call(() -> this.takenFuture.onComplete(runnable));
    }

    private void takeInternal(Predicate<Path> takeSnapshot) {
        SnapshotMetrics snapshotMetrics = this.snapshotStore.getSnapshotMetrics();
        try (Histogram.Timer ignored = snapshotMetrics.startTimer();){
            try {
                this.isValid = takeSnapshot.test(this.getPath());
                if (!this.isValid) {
                    this.abortInternal();
                } else if (!this.directory.toFile().exists() || this.directory.toFile().listFiles().length == 0) {
                    this.isValid = false;
                } else {
                    this.calculateAndPersistChecksum();
                }
                this.snapshot = null;
                this.takenFuture.complete((Object)this.isValid);
            }
            catch (Exception exception) {
                LOGGER.warn("Unexpected exception on taking snapshot ({})", (Object)this.metadata, (Object)exception);
                this.abortInternal();
                this.takenFuture.completeExceptionally((Throwable)exception);
            }
        }
    }

    private void calculateAndPersistChecksum() throws IOException {
        long checksum = SnapshotChecksum.calculate(this.directory);
        SnapshotChecksum.persist(this.directory, checksum);
    }

    @Override
    public ActorFuture<Void> abort() {
        CompletableActorFuture abortFuture = new CompletableActorFuture();
        this.actor.run(() -> {
            this.abortInternal();
            abortFuture.complete(null);
        });
        return abortFuture;
    }

    @Override
    public ActorFuture<PersistedSnapshot> persist() {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            if (this.snapshot != null) {
                future.complete((Object)this.snapshot);
                return;
            }
            if (!this.takenFuture.isDone()) {
                future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not taken"));
                return;
            }
            if (!this.isValid) {
                future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not valid. It may have been deleted."));
                return;
            }
            if (!SnapshotChecksum.hasChecksum(this.getPath())) {
                future.completeExceptionally((Throwable)new IllegalStateException("Snapshot is not valid. There is no checksum file."));
                return;
            }
            try {
                this.snapshot = this.snapshotStore.newSnapshot(this.metadata, this.directory);
                future.complete((Object)this.snapshot);
            }
            catch (Exception e) {
                future.completeExceptionally((Throwable)e);
            }
        });
        return future;
    }

    @Override
    public SnapshotId snapshotId() {
        return this.metadata;
    }

    private void abortInternal() {
        try {
            this.isValid = false;
            this.snapshot = null;
            LOGGER.debug("DELETE dir {}", (Object)this.directory);
            FileUtil.deleteFolder((Path)this.directory);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete pending snapshot {}", (Object)this, (Object)e);
        }
        finally {
            this.snapshotStore.removePendingSnapshot(this);
        }
    }

    private Path getPath() {
        return this.directory;
    }

    public String toString() {
        return "FileBasedTransientSnapshot{directory=" + this.directory + ", snapshotStore=" + this.snapshotStore + ", metadata=" + this.metadata + "}";
    }
}

