/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32C;

final class SnapshotChecksum {
    private static final String CHECKSUM_FILE_NAME = "CHECKSUM";

    private SnapshotChecksum() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean hasChecksum(Path snapshotDirectory) {
        File file = snapshotDirectory.resolve(CHECKSUM_FILE_NAME).toFile();
        return file.exists();
    }

    public static long read(Path snapshotDirectory) throws IOException {
        File file = snapshotDirectory.resolve(CHECKSUM_FILE_NAME).toFile();
        if (!file.exists()) {
            throw new IllegalStateException(String.format("Expected to find a checksum file named %s, but no such file exists.", CHECKSUM_FILE_NAME));
        }
        try (RandomAccessFile checksumFile = new RandomAccessFile(file, "r");){
            long l = checksumFile.readLong();
            return l;
        }
    }

    public static long calculate(Path snapshotDirectory) throws IOException {
        try (Stream<Path> fileStream = Files.list(snapshotDirectory).sorted();){
            long l = SnapshotChecksum.createCombinedChecksum(fileStream.filter(path -> !path.endsWith(CHECKSUM_FILE_NAME)).collect(Collectors.toList()));
            return l;
        }
    }

    public static void persist(Path snapshotDirectory, long checksum) throws IOException {
        File file = snapshotDirectory.resolve(CHECKSUM_FILE_NAME).toFile();
        if (file.createNewFile()) {
            try (RandomAccessFile checksumFile = new RandomAccessFile(file, "rw");){
                checksumFile.writeLong(checksum);
            }
        }
    }

    public static boolean verify(Path snapshotDirectory) throws IOException {
        long actualChecksum;
        long expectedChecksum = SnapshotChecksum.read(snapshotDirectory);
        return expectedChecksum == (actualChecksum = SnapshotChecksum.calculate(snapshotDirectory));
    }

    private static long createCombinedChecksum(List<Path> paths) throws IOException {
        CRC32C checksumGenerator = new CRC32C();
        ArrayList<Long> chunkChecksum = new ArrayList<Long>();
        for (Path path : paths) {
            if (path.endsWith(CHECKSUM_FILE_NAME)) continue;
            checksumGenerator.update(Files.readAllBytes(path));
            chunkChecksum.add(checksumGenerator.getValue());
            checksumGenerator.reset();
        }
        chunkChecksum.forEach(c -> checksumGenerator.update(ByteBuffer.allocate(8).putLong(0, (long)c)));
        return checksumGenerator.getValue();
    }
}

