/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import io.zeebe.snapshots.raft.SnapshotChunk;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.CRC32;

final class SnapshotChunkUtil {
    private SnapshotChunkUtil() {
    }

    static long createChecksum(byte[] content) {
        CRC32 crc32 = new CRC32();
        crc32.update(content);
        return crc32.getValue();
    }

    static SnapshotChunk createSnapshotChunkFromFile(File snapshotChunkFile, String snapshotId, int totalCount, long snapshotChecksum) throws IOException {
        byte[] content = Files.readAllBytes(snapshotChunkFile.toPath());
        long checksum = SnapshotChunkUtil.createChecksum(content);
        return new SnapshotChunkImpl(snapshotId, totalCount, snapshotChunkFile.getName(), checksum, content, snapshotChecksum);
    }

    private static final class SnapshotChunkImpl
    implements SnapshotChunk {
        private final String snapshotId;
        private final int totalCount;
        private final String chunkName;
        private final byte[] content;
        private final long snapshotChecksum;
        private final long checksum;

        SnapshotChunkImpl(String snapshotId, int totalCount, String chunkName, long checksum, byte[] content, long snapshotChecksum) {
            this.snapshotId = snapshotId;
            this.totalCount = totalCount;
            this.chunkName = chunkName;
            this.checksum = checksum;
            this.content = content;
            this.snapshotChecksum = snapshotChecksum;
        }

        @Override
        public String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public int getTotalCount() {
            return this.totalCount;
        }

        @Override
        public String getChunkName() {
            return this.chunkName;
        }

        @Override
        public long getChecksum() {
            return this.checksum;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }

        @Override
        public long getSnapshotChecksum() {
            return this.snapshotChecksum;
        }
    }
}

