/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.snapshots.broker.impl;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class SnapshotMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String PARTITION_LABEL_NAME = "partition";
    private static final Counter SNAPSHOT_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_count")).help("Total count of committed snapshots on disk")).register();
    private static final Gauge SNAPSHOT_SIZE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_size_bytes")).help("Estimated snapshot size on disk")).register();
    private static final Gauge SNAPSHOT_CHUNK_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_chunks_count")).help("Number of chunks in the last snapshot")).register();
    private static final Histogram SNAPSHOT_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).labelNames(new String[]{"partition"})).name("snapshot_duration")).help("Approximate duration of snapshot operation")).register();
    private static final Histogram SNAPSHOT_FILE_SIZE = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).labelNames(new String[]{"partition"})).help("Approximate size of snapshot files")).name("snapshot_file_size_megabytes")).buckets(new double[]{0.01, 0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0}).register();
    private final String partitionId;

    public SnapshotMetrics(String partitionName) {
        this.partitionId = partitionName;
    }

    void incrementSnapshotCount() {
        ((Counter.Child)SNAPSHOT_COUNT.labels(new String[]{this.partitionId})).inc();
    }

    void observeSnapshotSize(long sizeInBytes) {
        ((Gauge.Child)SNAPSHOT_SIZE.labels(new String[]{this.partitionId})).set((double)sizeInBytes);
    }

    void observeSnapshotChunkCount(long count) {
        ((Gauge.Child)SNAPSHOT_CHUNK_COUNT.labels(new String[]{this.partitionId})).set((double)count);
    }

    void observeSnapshotFileSize(long sizeInBytes) {
        ((Histogram.Child)SNAPSHOT_FILE_SIZE.labels(new String[]{this.partitionId})).observe((double)((float)sizeInBytes / 1000000.0f));
    }

    Histogram.Timer startTimer() {
        return ((Histogram.Child)SNAPSHOT_DURATION.labels(new String[]{this.partitionId})).startTimer();
    }
}

