/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.ManagedUnicastService;
import io.atomix.core.AtomixBuilder;
import io.atomix.core.AtomixConfig;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionService;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.config.ConfigurationException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Atomix
extends AtomixCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(Atomix.class);
    private static final String VERSION_RESOURCE = "VERSION";
    private static final String BUILD;
    private static final Version VERSION;
    private final ScheduledExecutorService executorService;
    private final ManagedPartitionService partitions;
    private final ThreadContext threadContext = new SingleThreadContext("atomix-%d");

    protected Atomix(AtomixConfig config) {
        this(config, null, null);
    }

    protected Atomix(AtomixConfig config, ManagedMessagingService messagingService, ManagedUnicastService unicastService) {
        super(config.getClusterConfig(), VERSION, messagingService, unicastService);
        this.executorService = Executors.newScheduledThreadPool(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 8), 4), Threads.namedThreads((String)"atomix-primitive-%d", (Logger)LOGGER));
        this.partitions = Atomix.buildPartitionService(config, this.getMembershipService(), this.getCommunicationService());
    }

    public static AtomixBuilder builder() {
        return Atomix.builder(new AtomixConfig());
    }

    public static AtomixBuilder builder(AtomixConfig config) {
        return new AtomixBuilder(config);
    }

    public PartitionService getPartitionService() {
        return this.partitions;
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Atomix instance " + (this.closeFuture.isDone() ? "shutdown" : "shutting down")));
        }
        LOGGER.info(BUILD);
        return super.start();
    }

    protected CompletableFuture<Void> startServices() {
        return ((CompletableFuture)super.startServices().thenComposeAsync(v -> this.partitions.start(), (Executor)this.threadContext)).thenApply(v -> null);
    }

    protected CompletableFuture<Void> stopServices() {
        return ((CompletableFuture)this.partitions.stop().exceptionally(e -> null)).thenComposeAsync(v -> super.stopServices(), (Executor)this.threadContext);
    }

    protected CompletableFuture<Void> completeShutdown() {
        this.executorService.shutdownNow();
        this.threadContext.close();
        return super.completeShutdown();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("partitions", (Object)this.getPartitionService()).toString();
    }

    private static ManagedPartitionService buildPartitionService(AtomixConfig config, ClusterMembershipService clusterMembershipService, ClusterCommunicationService messagingService) {
        ArrayList<ManagedPartitionGroup> partitionGroups = new ArrayList<ManagedPartitionGroup>();
        for (PartitionGroupConfig<?> partitionGroupConfig : config.getPartitionGroups().values()) {
            partitionGroups.add(((PartitionGroup.Type)partitionGroupConfig.getType()).newPartitionGroup(partitionGroupConfig));
        }
        return new DefaultPartitionService(clusterMembershipService, messagingService, partitionGroups);
    }

    static {
        try {
            BUILD = Resources.toString((URL)((URL)Preconditions.checkNotNull((Object)Atomix.class.getClassLoader().getResource(VERSION_RESOURCE), (Object)"VERSION resource is null")), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            throw new ConfigurationException("Failed to load Atomix version", (Throwable)e);
        }
        VERSION = BUILD.trim().length() > 0 ? Version.from((String)BUILD.trim().split("\\s+")[0]) : null;
    }
}

