/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core;

import com.google.common.base.Preconditions;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.utils.net.Address;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class AtomixBuilder
extends AtomixClusterBuilder {
    private final AtomixConfig atomixConfig;

    AtomixBuilder(AtomixConfig atomixConfig) {
        super(atomixConfig.getClusterConfig());
        this.atomixConfig = (AtomixConfig)Preconditions.checkNotNull((Object)atomixConfig);
    }

    public AtomixBuilder withPartitionGroups(ManagedPartitionGroup ... partitionGroups) {
        return this.withPartitionGroups(Arrays.asList((ManagedPartitionGroup[])Preconditions.checkNotNull((Object)partitionGroups, (Object)"partitionGroups cannot be null")));
    }

    public AtomixBuilder withPartitionGroups(Collection<ManagedPartitionGroup> partitionGroups) {
        partitionGroups.forEach(group -> this.atomixConfig.addPartitionGroup((PartitionGroupConfig)group.config()));
        return this;
    }

    public AtomixBuilder withClusterId(String clusterId) {
        super.withClusterId(clusterId);
        return this;
    }

    public AtomixBuilder withMemberId(String localMemberId) {
        super.withMemberId(localMemberId);
        return this;
    }

    public AtomixBuilder withMemberId(MemberId localMemberId) {
        super.withMemberId(localMemberId);
        return this;
    }

    public AtomixBuilder withHost(String host) {
        super.withHost(host);
        return this;
    }

    public AtomixBuilder withPort(int port) {
        super.withPort(port);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(String address) {
        super.withAddress(address);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(String host, int port) {
        super.withAddress(host, port);
        return this;
    }

    @Deprecated
    public AtomixBuilder withAddress(int port) {
        super.withAddress(port);
        return this;
    }

    public AtomixBuilder withAddress(Address address) {
        super.withAddress(address);
        return this;
    }

    public AtomixBuilder withZoneId(String zoneId) {
        super.withZoneId(zoneId);
        return this;
    }

    @Deprecated
    public AtomixBuilder withZone(String zone) {
        super.withZone(zone);
        return this;
    }

    public AtomixBuilder withRackId(String rackId) {
        super.withRackId(rackId);
        return this;
    }

    @Deprecated
    public AtomixBuilder withRack(String rack) {
        super.withRack(rack);
        return this;
    }

    public AtomixBuilder withHostId(String hostId) {
        super.withHostId(hostId);
        return this;
    }

    public AtomixBuilder withProperties(Properties properties) {
        super.withProperties(properties);
        return this;
    }

    public AtomixBuilder withProperty(String key, String value) {
        super.withProperty(key, value);
        return this;
    }

    public AtomixBuilder withMessagingInterface(String iface) {
        super.withMessagingInterface(iface);
        return this;
    }

    public AtomixBuilder withMessagingInterfaces(String ... ifaces) {
        super.withMessagingInterfaces(ifaces);
        return this;
    }

    public AtomixBuilder withMessagingInterfaces(Collection<String> ifaces) {
        super.withMessagingInterfaces(ifaces);
        return this;
    }

    public AtomixBuilder withMessagingPort(int bindPort) {
        super.withMessagingPort(bindPort);
        return this;
    }

    public AtomixBuilder withConnectionPoolSize(int connectionPoolSize) {
        super.withConnectionPoolSize(connectionPoolSize);
        return this;
    }

    public AtomixBuilder setBroadcastInterval(Duration interval) {
        super.setBroadcastInterval(interval);
        return this;
    }

    public AtomixBuilder setReachabilityThreshold(int threshold) {
        super.setReachabilityThreshold(threshold);
        return this;
    }

    public AtomixBuilder withReachabilityTimeout(Duration timeout) {
        super.withReachabilityTimeout(timeout);
        return this;
    }

    public AtomixBuilder withMembershipProtocol(GroupMembershipProtocol protocol) {
        super.withMembershipProtocol(protocol);
        return this;
    }

    public AtomixBuilder withMembershipProvider(NodeDiscoveryProvider locationProvider) {
        super.withMembershipProvider(locationProvider);
        return this;
    }

    public Atomix build() {
        return new Atomix(this.atomixConfig);
    }
}

