/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher;

import io.zeebe.dispatcher.impl.PositionUtil;
import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class ClaimedFragmentBatch {
    private static final String ERROR_MESSAGE = "The given fragment length is greater than the remaining capacity. offset: %d, length: %d, capacity: %d";
    private static final int FIRST_FRAGMENT_OFFSET = 0;
    private final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
    private int partitionId;
    private int partitionOffset;
    private int currentOffset;
    private int nextOffset;
    private Runnable onCompleteHandler;

    public void wrap(UnsafeBuffer underlyingBuffer, int partitionId, int fragmentOffset, int fragmentLength, Runnable onCompleteHandler) {
        this.buffer.wrap((DirectBuffer)underlyingBuffer, fragmentOffset, fragmentLength);
        this.partitionId = partitionId;
        this.partitionOffset = fragmentOffset;
        this.currentOffset = 0;
        this.nextOffset = 0;
        this.onCompleteHandler = onCompleteHandler;
    }

    public MutableDirectBuffer getBuffer() {
        return this.buffer;
    }

    public int getFragmentOffset() {
        return this.currentOffset + DataFrameDescriptor.HEADER_LENGTH;
    }

    public long nextFragment(int length, int streamId) {
        this.currentOffset = this.nextOffset;
        int framedLength = DataFrameDescriptor.framedLength(length);
        this.nextOffset += DataFrameDescriptor.alignedLength(framedLength);
        int remainingCapacity = this.buffer.capacity() - this.nextOffset;
        if (remainingCapacity < 0 || 8 <= remainingCapacity && remainingCapacity < DataFrameDescriptor.HEADER_LENGTH) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, this.currentOffset, length, this.buffer.capacity()));
        }
        this.buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(this.currentOffset), -framedLength);
        UnsafeAccess.UNSAFE.storeFence();
        this.buffer.putShort(DataFrameDescriptor.typeOffset(this.currentOffset), (short)0);
        this.buffer.putInt(DataFrameDescriptor.streamIdOffset(this.currentOffset), streamId);
        return PositionUtil.position(this.partitionId, this.partitionOffset + this.nextOffset);
    }

    public void commit() {
        int firstFragmentFramedLength = -this.buffer.getInt(DataFrameDescriptor.lengthOffset(0));
        if (this.currentOffset > 0) {
            int fragmentFramedLength;
            byte firstFragmentFlags = this.buffer.getByte(DataFrameDescriptor.flagsOffset(0));
            this.buffer.putByte(DataFrameDescriptor.flagsOffset(0), DataFrameDescriptor.enableFlagBatchBegin(firstFragmentFlags));
            for (int fragmentOffset = DataFrameDescriptor.alignedLength(firstFragmentFramedLength); fragmentOffset < this.nextOffset; fragmentOffset += DataFrameDescriptor.alignedLength(fragmentFramedLength)) {
                fragmentFramedLength = -this.buffer.getInt(DataFrameDescriptor.lengthOffset(fragmentOffset));
                this.buffer.putInt(DataFrameDescriptor.lengthOffset(fragmentOffset), fragmentFramedLength);
            }
            byte lastFragmentFlags = this.buffer.getByte(DataFrameDescriptor.flagsOffset(this.currentOffset));
            this.buffer.putByte(DataFrameDescriptor.flagsOffset(this.currentOffset), DataFrameDescriptor.enableFlagBatchEnd(lastFragmentFlags));
        }
        this.fillRemainingBatchSize();
        this.buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(0), firstFragmentFramedLength);
        this.onCompleteHandler.run();
        this.reset();
    }

    public void abort() {
        int fragmentLength;
        for (int fragmentOffset = 0; fragmentOffset < this.nextOffset; fragmentOffset += DataFrameDescriptor.alignedLength(fragmentLength)) {
            fragmentLength = -this.buffer.getInt(DataFrameDescriptor.lengthOffset(fragmentOffset));
            this.buffer.putInt(DataFrameDescriptor.typeOffset(fragmentOffset), 1);
            this.buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(fragmentOffset), fragmentLength);
        }
        this.fillRemainingBatchSize();
        this.onCompleteHandler.run();
        this.reset();
    }

    private void fillRemainingBatchSize() {
        int remainingLength = this.buffer.capacity() - this.nextOffset;
        if (remainingLength >= DataFrameDescriptor.HEADER_LENGTH) {
            this.buffer.putInt(DataFrameDescriptor.lengthOffset(this.nextOffset), remainingLength);
            this.buffer.putShort(DataFrameDescriptor.typeOffset(this.nextOffset), (short)1);
        }
    }

    private void reset() {
        this.buffer.wrap(0L, 0);
        this.onCompleteHandler = null;
    }
}

