/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher.impl.log;

public final class LogBufferDescriptor {
    public static final int PARTITION_COUNT = 3;
    public static final int PARTITION_MIN_LENGTH = 65536;
    public static final int PARTITION_CLEAN = 0;
    public static final int PARTITION_NEEDS_CLEANING = 1;
    public static final int PARTITION_TAIL_COUNTER_OFFSET;
    public static final int PARTITION_STATUS_OFFSET;
    public static final int PARTITION_META_DATA_LENGTH;
    public static final int LOG_PUBLISHER_LIMIT_OFFSET;
    public static final int LOG_ACTIVE_PARTITION_ID_OFFSET;
    public static final int LOG_MAX_FRAME_LENGTH_OFFSET;
    public static final int LOG_META_DATA_LENGTH;

    public static int requiredCapacity(int partitionSize) {
        return 3 * (partitionSize + PARTITION_META_DATA_LENGTH) + LOG_META_DATA_LENGTH;
    }

    public static int partitionMetadataSectionOffset(int partitionSize, int partitionNumber) {
        return 3 * partitionSize + partitionNumber * PARTITION_META_DATA_LENGTH;
    }

    public static int partitionDataSectionOffset(int partitionSize, int partitionNumber) {
        return partitionNumber * partitionSize;
    }

    public static int logMetadataOffset(int partitionSize) {
        return 3 * partitionSize + 3 * PARTITION_META_DATA_LENGTH;
    }

    static {
        int offset;
        PARTITION_TAIL_COUNTER_OFFSET = offset = 128;
        PARTITION_STATUS_OFFSET = offset += 128;
        PARTITION_META_DATA_LENGTH = offset += 128;
        LOG_PUBLISHER_LIMIT_OFFSET = offset = 0;
        LOG_ACTIVE_PARTITION_ID_OFFSET = offset += 128;
        LOG_MAX_FRAME_LENGTH_OFFSET = offset += 128;
        LOG_META_DATA_LENGTH = offset += 4;
    }
}

