/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import java.time.Clock;
import me.dinowernli.grpc.prometheus.ClientMetrics;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.MonitoringClientCallListener;

class MonitoringClientCall<R, S>
extends ForwardingClientCall.SimpleForwardingClientCall<R, S> {
    private final ClientMetrics clientMetrics;
    private final GrpcMethod grpcMethod;
    private final Configuration configuration;
    private final Clock clock;

    MonitoringClientCall(ClientCall<R, S> clientCall, ClientMetrics clientMetrics, GrpcMethod grpcMethod, Configuration configuration, Clock clock) {
        super(clientCall);
        this.clientMetrics = clientMetrics;
        this.grpcMethod = grpcMethod;
        this.configuration = configuration;
        this.clock = clock;
    }

    public void start(ClientCall.Listener<S> listener, Metadata metadata) {
        this.clientMetrics.recordCallStarted();
        super.start(new MonitoringClientCallListener<S>(listener, this.clientMetrics, this.grpcMethod, this.configuration, this.clock), metadata);
    }

    public void sendMessage(R r) {
        if (this.grpcMethod.streamsRequests()) {
            this.clientMetrics.recordStreamMessageSent();
        }
        super.sendMessage(r);
    }
}

