/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Either<L, R> {
    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public boolean isRight();

    public boolean isLeft();

    public R get();

    public L getLeft();

    public <T> Either<L, T> map(Function<? super R, ? extends T> var1);

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> var1);

    public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> var1);

    public void ifRight(Consumer<R> var1);

    public void ifLeft(Consumer<L> var1);

    public void ifRightOrLeft(Consumer<R> var1, Consumer<L> var2);

    public static final class Left<L, R>
    implements Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public R get() {
            throw new NoSuchElementException("Expected a right, but this is left");
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public <T> Either<L, T> map(Function<? super R, ? extends T> right) {
            return this;
        }

        @Override
        public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> left) {
            return Either.left(left.apply(this.value));
        }

        @Override
        public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> right) {
            return this;
        }

        @Override
        public void ifRight(Consumer<R> right) {
        }

        @Override
        public void ifLeft(Consumer<L> action) {
            action.accept(this.value);
        }

        @Override
        public void ifRightOrLeft(Consumer<R> rightAction, Consumer<L> leftAction) {
            leftAction.accept(this.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return Objects.equals(this.value, left.value);
        }

        public String toString() {
            return "Left[" + this.value + "]";
        }
    }

    public static final class Right<L, R>
    implements Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public R get() {
            return this.value;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Expected a left, but this is right");
        }

        @Override
        public <T> Either<L, T> map(Function<? super R, ? extends T> right) {
            return Either.right(right.apply(this.value));
        }

        @Override
        public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> left) {
            return this;
        }

        @Override
        public <T> Either<L, T> flatMap(Function<? super R, ? extends Either<L, T>> right) {
            return right.apply(this.value);
        }

        @Override
        public void ifRight(Consumer<R> right) {
            right.accept(this.value);
        }

        @Override
        public void ifLeft(Consumer<L> action) {
        }

        @Override
        public void ifRightOrLeft(Consumer<R> rightAction, Consumer<L> leftAction) {
            rightAction.accept(this.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return Objects.equals(this.value, right.value);
        }

        public String toString() {
            return "Right[" + this.value + "]";
        }
    }
}

