/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.Loggers;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public final class FileUtil {
    public static final Logger LOG = Loggers.FILE_LOGGER;

    private FileUtil() {
    }

    public static void deleteFolder(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        FileUtil.deleteFolder(directory);
    }

    public static void ensureDirectoryExists(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new NotDirectoryException(directory.toString());
            }
        } else {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    public static void deleteFolder(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copySnapshot(Path runtimeDirectory, Path snapshotDirectory) throws Exception {
        Files.walkFileTree(snapshotDirectory, new SnapshotCopier(snapshotDirectory, runtimeDirectory));
    }

    public static final class SnapshotCopier
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private final Path sourcePath;

        SnapshotCopier(Path sourcePath, Path targetPath) {
            this.sourcePath = sourcePath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.targetPath.resolve(this.sourcePath.relativize(dir));
            try {
                Files.copy(dir, newDirectory, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException ioException) {
                LOG.error("Problem on copying snapshot to runtime.", (Throwable)ioException);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path newFile = this.targetPath.resolve(this.sourcePath.relativize(file));
            try {
                Files.copy(file, newFile, new CopyOption[0]);
            }
            catch (IOException ioException) {
                LOG.error("Problem on copying {} to {}.", new Object[]{file, newFile, ioException});
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            LOG.error("Problem on copying snapshot to runtime.", (Throwable)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

