/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.MDC;

public final class LogUtil {
    public static void doWithMDC(Map<String, String> context, Runnable r) {
        Map currentContext = MDC.getCopyOfContextMap();
        MDC.setContextMap(context);
        try {
            r.run();
        }
        finally {
            if (currentContext != null) {
                MDC.setContextMap((Map)currentContext);
            } else {
                MDC.clear();
            }
        }
    }

    public static void catchAndLog(Logger log, ThrowingRunnable r) {
        try {
            r.run();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

