/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util;

import io.zeebe.util.Loggers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public final class VersionUtil {
    public static final Logger LOG = Loggers.FILE_LOGGER;
    private static final String VERSION_PROPERTIES_PATH = "/zeebe-util.properties";
    private static final String VERSION_PROPERTY_NAME = "zeebe.version";
    private static final String LAST_VERSION_PROPERTY_NAME = "zeebe.last.version";
    private static final String VERSION_DEV = "development";
    private static String version;
    private static String versionLowerCase;
    private static String lastVersion;

    private VersionUtil() {
    }

    public static String getVersion() {
        if (version == null) {
            version = VersionUtil.readProperty(VERSION_PROPERTY_NAME);
            if (version == null) {
                LOG.warn("Version is not found in version file.");
                version = VersionUtil.class.getPackage().getImplementationVersion();
            }
            if (version == null) {
                version = VERSION_DEV;
            }
        }
        return version;
    }

    public static String getVersionLowerCase() {
        if (versionLowerCase == null) {
            versionLowerCase = VersionUtil.getVersion().toLowerCase();
        }
        return versionLowerCase;
    }

    public static String getPreviousVersion() {
        if (lastVersion == null) {
            lastVersion = VersionUtil.readProperty(LAST_VERSION_PROPERTY_NAME);
        }
        return lastVersion;
    }

    private static String readProperty(String property) {
        String string;
        block8: {
            InputStream lastVersionFileStream = VersionUtil.class.getResourceAsStream(VERSION_PROPERTIES_PATH);
            try {
                Properties props = new Properties();
                props.load(lastVersionFileStream);
                string = props.getProperty(property);
                if (lastVersionFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lastVersionFileStream != null) {
                        try {
                            lastVersionFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error(String.format("Can't read version file: %s", VERSION_PROPERTIES_PATH), (Throwable)e);
                    return null;
                }
            }
            lastVersionFileStream.close();
        }
        return string;
    }
}

