/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.retry;

import io.zeebe.util.retry.ActorRetryMechanism;
import io.zeebe.util.retry.OperationToRetry;
import io.zeebe.util.retry.RetryStrategy;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.BooleanSupplier;

public final class AbortableRetryStrategy
implements RetryStrategy {
    private final ActorControl actor;
    private final ActorRetryMechanism retryMechanism;
    private CompletableActorFuture<Boolean> currentFuture;

    public AbortableRetryStrategy(ActorControl actor) {
        this.actor = actor;
        this.retryMechanism = new ActorRetryMechanism(actor);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier condition) {
        this.currentFuture = new CompletableActorFuture();
        this.retryMechanism.wrap(callable, condition, this.currentFuture);
        this.actor.runUntilDone(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            this.retryMechanism.run();
        }
        catch (Exception exception) {
            this.currentFuture.completeExceptionally(exception);
            this.actor.done();
        }
    }
}

