/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.retry;

import io.zeebe.util.retry.ActorRetryMechanism;
import io.zeebe.util.retry.OperationToRetry;
import io.zeebe.util.retry.RetryStrategy;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndlessRetryStrategy
implements RetryStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EndlessRetryStrategy.class);
    private final ActorControl actor;
    private final ActorRetryMechanism retryMechanism;
    private CompletableActorFuture<Boolean> currentFuture;
    private BooleanSupplier terminateCondition;

    public EndlessRetryStrategy(ActorControl actor) {
        this.actor = actor;
        this.retryMechanism = new ActorRetryMechanism(actor);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable) {
        return this.runWithRetry(callable, () -> false);
    }

    @Override
    public ActorFuture<Boolean> runWithRetry(OperationToRetry callable, BooleanSupplier condition) {
        this.currentFuture = new CompletableActorFuture();
        this.terminateCondition = condition;
        this.retryMechanism.wrap(callable, this.terminateCondition, this.currentFuture);
        this.actor.runUntilDone(this::run);
        return this.currentFuture;
    }

    private void run() {
        try {
            this.retryMechanism.run();
        }
        catch (Exception exception) {
            if (this.terminateCondition.getAsBoolean()) {
                this.currentFuture.complete(false);
                this.actor.done();
            }
            this.actor.yield();
            LOG.error("Catched exception {} with message {}, will retry...", new Object[]{exception.getClass(), exception.getMessage(), exception});
        }
    }
}

