/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.CloseableSilently;
import io.zeebe.util.Loggers;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.AsyncClosable;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class Actor
implements CloseableSilently,
AsyncClosable {
    private static final int MAX_CLOSE_TIMEOUT = 300;
    protected final ActorControl actor = new ActorControl(this);

    public String getName() {
        return this.getClass().getName();
    }

    public boolean isActorClosed() {
        return this.actor.isClosed();
    }

    protected void onActorStarting() {
    }

    protected void onActorStarted() {
    }

    protected void onActorClosing() {
    }

    protected void onActorClosed() {
    }

    protected void onActorCloseRequested() {
    }

    public static Actor wrap(final Consumer<ActorControl> r) {
        return new Actor(){

            @Override
            public String getName() {
                return r.toString();
            }

            @Override
            protected void onActorStarted() {
                r.accept(this.actor);
            }
        };
    }

    @Override
    public void close() {
        this.closeAsync().join(300L, TimeUnit.SECONDS);
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        return this.actor.close();
    }

    public static String buildActorName(int nodeId, String name) {
        return String.format("Broker-%d-%s", nodeId, name);
    }

    public static String buildActorName(int nodeId, String name, int partitionId) {
        return String.format("Broker-%d-%s-%d", nodeId, name, partitionId);
    }

    protected void handleFailure(Exception failure) {
        Loggers.ACTOR_LOGGER.error("Uncaught exception in '{}' in phase '{}'. Continuing with next job.", new Object[]{this.getName(), this.actor.getLifecyclePhase(), failure});
    }

    public void onActorFailed() {
    }
}

