/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThreadGroup;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.CompletableFuture;

public final class ActorExecutor {
    private final ActorThreadGroup cpuBoundThreads;
    private final ActorThreadGroup ioBoundThreads;

    public ActorExecutor(ActorScheduler.ActorSchedulerBuilder builder) {
        this.ioBoundThreads = builder.getIoBoundActorThreads();
        this.cpuBoundThreads = builder.getCpuBoundActorThreads();
    }

    public ActorFuture<Void> submitCpuBound(ActorTask task) {
        return this.submitTask(task, this.cpuBoundThreads);
    }

    public ActorFuture<Void> submitIoBoundTask(ActorTask task) {
        return this.submitTask(task, this.ioBoundThreads);
    }

    private ActorFuture<Void> submitTask(ActorTask task, ActorThreadGroup threadGroup) {
        if (task.getLifecyclePhase() != ActorTask.ActorLifecyclePhase.CLOSED) {
            throw new IllegalStateException("ActorTask was already submitted!");
        }
        ActorFuture<Void> startingFuture = task.onTaskScheduled(this, threadGroup);
        threadGroup.submit(task);
        return startingFuture;
    }

    public void start() {
        this.cpuBoundThreads.start();
        this.ioBoundThreads.start();
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.allOf(this.ioBoundThreads.closeAsync(), this.cpuBoundThreads.closeAsync());
    }

    public ActorThreadGroup getCpuBoundThreads() {
        return this.cpuBoundThreads;
    }

    public ActorThreadGroup getIoBoundThreads() {
        return this.ioBoundThreads;
    }
}

