/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import io.zeebe.util.Loggers;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.ActorThread;
import io.zeebe.util.sched.MultiLevelWorkstealingGroup;
import io.zeebe.util.sched.TaskScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;

public abstract class ActorThreadGroup {
    protected final String groupName;
    protected final ActorThread[] threads;
    protected final MultiLevelWorkstealingGroup tasks;
    protected final int numOfThreads;

    public ActorThreadGroup(String groupName, int numOfThreads, int numOfQueuesPerThread, ActorScheduler.ActorSchedulerBuilder builder) {
        this.groupName = groupName;
        this.numOfThreads = numOfThreads;
        this.tasks = new MultiLevelWorkstealingGroup(numOfThreads, numOfQueuesPerThread);
        this.threads = new ActorThread[numOfThreads];
        for (int t = 0; t < numOfThreads; ++t) {
            ActorThread thread;
            String threadName = String.format("%s-%d", groupName, t);
            TaskScheduler taskScheduler = this.createTaskScheduler(this.tasks, builder);
            this.threads[t] = thread = builder.getActorThreadFactory().newThread(threadName, t, this, taskScheduler, builder.getActorClock(), builder.getActorTimerQueue());
        }
    }

    protected abstract TaskScheduler createTaskScheduler(MultiLevelWorkstealingGroup var1, ActorScheduler.ActorSchedulerBuilder var2);

    public void submit(ActorTask actorTask) {
        int level = this.getLevel(actorTask);
        ActorThread current = ActorThread.current();
        if (current != null && current.getActorThreadGroup() == this) {
            this.tasks.submit(actorTask, level, current.getRunnerId());
        } else {
            int threadId = ThreadLocalRandom.current().nextInt(this.numOfThreads);
            this.tasks.submit(actorTask, level, threadId);
            this.threads[threadId].hintWorkAvailable();
        }
    }

    protected abstract int getLevel(ActorTask var1);

    public String getGroupName() {
        return this.groupName;
    }

    public int getNumOfThreads() {
        return this.numOfThreads;
    }

    public void start() {
        for (ActorThread actorThread : this.threads) {
            actorThread.start();
        }
    }

    public CompletableFuture<Void> closeAsync() {
        Loggers.ACTOR_LOGGER.debug("Closing actor thread ground '{}'", (Object)this.groupName);
        CompletableFuture[] terminationFutures = new CompletableFuture[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            ActorThread thread = this.threads[i];
            try {
                terminationFutures[i] = thread.close();
                continue;
            }
            catch (IllegalStateException e) {
                Loggers.ACTOR_LOGGER.error("Closing actor thread ground '{}'. Failed to close thread {}", new Object[]{this.groupName, thread.getRunnerId(), e});
                terminationFutures[i] = CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.allOf(terminationFutures).thenAccept(ok -> Loggers.ACTOR_LOGGER.debug("Closing actor thread ground '{}': closed successfully", (Object)this.groupName));
    }
}

