/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.agrona.LangUtil;

public final class FutureUtil {
    public static <T> T join(Future<T> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    public static <T> T join(Future<T> f, long timeout, TimeUnit timeUnit) {
        try {
            return f.get(timeout, timeUnit);
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    public static Runnable wrap(Future<?> future) {
        return () -> {
            try {
                future.get();
            }
            catch (Exception e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        };
    }
}

