/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class RunnableAdapter<T>
implements Runnable {
    private final Callable<T> callable;
    private T value;
    private Throwable exception;

    public RunnableAdapter(Callable<T> callable) {
        this.callable = callable;
    }

    @Override
    public void run() {
        try {
            this.value = this.callable.call();
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public static <T> RunnableAdapter<T> wrapCallable(Callable<T> callable) {
        return new RunnableAdapter<T>(callable);
    }

    public static RunnableAdapter<Void> wrapRunnable(Runnable callable) {
        return new RunnableAdapter<Void>(() -> {
            callable.run();
            return null;
        });
    }

    public Runnable wrapBiConsumer(BiConsumer<T, Throwable> consumer) {
        return () -> consumer.accept(this.value, this.exception);
    }

    public Runnable wrapConsumer(Consumer<Throwable> consumer) {
        return () -> consumer.accept(this.exception);
    }
}

