/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.channel;

import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.ActorJob;
import io.zeebe.util.sched.ActorSubscription;
import io.zeebe.util.sched.ActorTask;
import io.zeebe.util.sched.channel.ChannelSubscription;
import io.zeebe.util.sched.channel.ConsumableChannel;
import org.agrona.UnsafeAccess;

public final class ChannelConsumerCondition
implements ActorCondition,
ActorSubscription,
ChannelSubscription {
    private static final long TRIGGER_COUNT_OFFSET;
    private final ConsumableChannel channel;
    private final ActorJob job;
    private final ActorTask task;
    private final long triggerCount = 0L;
    private long processedTiggersCount = 0L;

    public ChannelConsumerCondition(ActorJob job, ConsumableChannel channel) {
        this.job = job;
        this.task = job.getTask();
        this.channel = channel;
    }

    @Override
    public boolean poll() {
        long polledCount = 0L;
        boolean hasAvailable = this.channel.hasAvailable();
        return 0L > this.processedTiggersCount || hasAvailable;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public void onJobCompleted() {
        ++this.processedTiggersCount;
    }

    @Override
    public void signal() {
        UnsafeAccess.UNSAFE.getAndAddLong(this, TRIGGER_COUNT_OFFSET, 1L);
        this.task.tryWakeup();
    }

    @Override
    public void cancel() {
        this.channel.removeConsumer(this);
        this.task.onSubscriptionCancelled(this);
    }

    static {
        try {
            TRIGGER_COUNT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ChannelConsumerCondition.class.getDeclaredField("triggerCount"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

