/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.channel;

import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.channel.ActorConditions;
import io.zeebe.util.sched.channel.ConsumableChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Consumer;

public final class ConcurrentQueueChannel<E>
implements Queue<E>,
ConsumableChannel {
    private final ActorConditions actorConditions = new ActorConditions();
    private final Queue<E> wrapped;

    public ConcurrentQueueChannel(Queue<E> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean hasAvailable() {
        return !this.isEmpty();
    }

    @Override
    public void registerConsumer(ActorCondition onDataAvailable) {
        this.actorConditions.registerConsumer(onDataAvailable);
    }

    @Override
    public void removeConsumer(ActorCondition onDataAvailable) {
        this.actorConditions.removeConsumer(onDataAvailable);
    }

    @Override
    public boolean add(E e) {
        if (this.wrapped.add(e)) {
            this.actorConditions.signalConsumers();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (this.wrapped.offer(e)) {
            this.actorConditions.signalConsumers();
            return true;
        }
        return false;
    }

    @Override
    public E remove() {
        return this.wrapped.remove();
    }

    @Override
    public E poll() {
        return this.wrapped.poll();
    }

    @Override
    public E element() {
        return this.wrapped.element();
    }

    @Override
    public E peek() {
        return this.wrapped.peek();
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        throw new UnsupportedOperationException();
    }
}

