/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.util.sched.clock;

import io.zeebe.util.sched.clock.ActorClock;

public final class DefaultActorClock
implements ActorClock {
    long timeMillis;
    long nanoTime;
    long nanoTimeOfLastMilli;
    long nanosSinceLastMilli;

    @Override
    public boolean update() {
        this.updateNanos();
        if (this.nanosSinceLastMilli >= 1000000L) {
            this.timeMillis = System.currentTimeMillis();
            this.nanoTimeOfLastMilli = this.nanoTime;
            return true;
        }
        return false;
    }

    @Override
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @Override
    public long getNanosSinceLastMillisecond() {
        return this.nanosSinceLastMilli;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    private void updateNanos() {
        this.nanoTime = System.nanoTime();
        this.nanosSinceLastMilli = this.nanoTime - this.nanoTimeOfLastMilli;
    }
}

