/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport;

import io.atomix.cluster.messaging.MessagingService;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.impl.AtomixClientTransportAdapter;
import io.zeebe.transport.impl.AtomixServerTransport;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;

public final class TransportFactory {
    private final ActorScheduler actorScheduler;

    public TransportFactory(ActorScheduler actorScheduler) {
        this.actorScheduler = actorScheduler;
    }

    public ServerTransport createServerTransport(int nodeId, MessagingService messagingService) {
        AtomixServerTransport atomixServerTransport = new AtomixServerTransport(nodeId, messagingService);
        this.actorScheduler.submitActor((Actor)atomixServerTransport);
        return atomixServerTransport;
    }

    public ClientTransport createClientTransport(MessagingService messagingService) {
        AtomixClientTransportAdapter atomixClientTransportAdapter = new AtomixClientTransportAdapter(messagingService);
        this.actorScheduler.submitActor((Actor)atomixClientTransportAdapter);
        return atomixClientTransportAdapter;
    }
}

