/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.atomix.cluster.messaging.MessagingException;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.utils.net.Address;
import io.zeebe.transport.ClientRequest;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.impl.RequestContext;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.net.ConnectException;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixClientTransportAdapter
extends Actor
implements ClientTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixClientTransportAdapter.class);
    private static final Duration RETRY_DELAY = Duration.ofMillis(10L);
    private static final String NO_REMOTE_ADDRESS_FOUND_ERROR_MESSAGE = "Failed to send request to %s, no remote address found.";
    private final MessagingService messagingService;

    public AtomixClientTransportAdapter(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    @Override
    public ActorFuture<DirectBuffer> sendRequestWithRetry(Supplier<String> nodeAddressSupplier, Predicate<DirectBuffer> responseValidator, ClientRequest clientRequest, Duration timeout) {
        return this.sendRequestInternal(nodeAddressSupplier, responseValidator, clientRequest, true, timeout);
    }

    @Override
    public ActorFuture<DirectBuffer> sendRequest(Supplier<String> nodeAddressSupplier, ClientRequest clientRequest, Duration timeout) {
        return this.sendRequestInternal(nodeAddressSupplier, r -> true, clientRequest, false, timeout);
    }

    private ActorFuture<DirectBuffer> sendRequestInternal(Supplier<String> nodeAddressSupplier, Predicate<DirectBuffer> responseValidator, ClientRequest clientRequest, boolean shouldRetry, Duration timeout) {
        int length = clientRequest.getLength();
        byte[] requestBytes = new byte[length];
        UnsafeBuffer buffer = new UnsafeBuffer(requestBytes);
        clientRequest.write((MutableDirectBuffer)buffer, 0);
        int partitionId = clientRequest.getPartitionId();
        CompletableActorFuture requestFuture = new CompletableActorFuture();
        RequestContext requestContext = new RequestContext((CompletableActorFuture<DirectBuffer>)requestFuture, nodeAddressSupplier, partitionId, requestBytes, responseValidator, shouldRetry, timeout);
        this.actor.call(() -> {
            ScheduledTimer scheduledTimer = this.actor.runDelayed(timeout, () -> this.timeoutFuture(requestContext));
            requestContext.setScheduledTimer(scheduledTimer);
            this.tryToSend(requestContext);
        });
        return requestFuture;
    }

    private void tryToSend(RequestContext requestContext) {
        if (requestContext.isDone()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request {} is already done", (Object)requestContext.hashCode());
            }
            return;
        }
        Duration calculateTimeout = requestContext.calculateTimeout();
        if (calculateTimeout.toMillis() <= 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request {} reached timeout of {}, current calculation {}", new Object[]{requestContext.hashCode(), requestContext.getTimeout(), calculateTimeout});
            }
            return;
        }
        Address nodeAddress = requestContext.getNodeAddress();
        if (nodeAddress == null) {
            if (requestContext.shouldRetry()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No target address for request {}, retry after {}.", (Object)requestContext.hashCode(), (Object)RETRY_DELAY);
                }
                this.actor.runDelayed(RETRY_DELAY, () -> this.tryToSend(requestContext));
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No target address for request {}, will fail request.", (Object)requestContext.hashCode());
                }
                requestContext.completeExceptionally(new ConnectException(String.format(NO_REMOTE_ADDRESS_FOUND_ERROR_MESSAGE, requestContext.getTopicName())));
            }
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Send request {} to {} with topic {}", new Object[]{requestContext.hashCode(), requestContext.getNodeAddress(), requestContext.getTopicName()});
        }
        byte[] requestBytes = requestContext.getRequestBytes();
        this.messagingService.sendAndReceive(nodeAddress, requestContext.getTopicName(), requestBytes, calculateTimeout).whenComplete((response, errorOnRequest) -> this.actor.run(() -> this.handleResponse(requestContext, (byte[])response, (Throwable)errorOnRequest)));
    }

    private void handleResponse(RequestContext requestContext, byte[] response, Throwable errorOnRequest) {
        if (requestContext.isDone()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Handle response, but request {} is already done", (Object)requestContext.hashCode());
            }
            return;
        }
        if (errorOnRequest == null) {
            UnsafeBuffer responseBuffer = new UnsafeBuffer(response);
            if (requestContext.verifyResponse((DirectBuffer)responseBuffer)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Got valid response for request {}.", (Object)requestContext.hashCode());
                }
                requestContext.complete((DirectBuffer)responseBuffer);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Got invalid response for request {}, retry in {}.", (Object)requestContext.hashCode(), (Object)RETRY_DELAY);
                }
                this.actor.runDelayed(RETRY_DELAY, () -> this.tryToSend(requestContext));
            }
        } else {
            Throwable cause = errorOnRequest.getCause();
            if ((this.exceptionShowsConnectionIssue(errorOnRequest) || this.exceptionShowsConnectionIssue(cause)) && requestContext.shouldRetry()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Request {} failed, but will retry after delay {}", new Object[]{requestContext.hashCode(), RETRY_DELAY, errorOnRequest});
                }
                this.actor.runDelayed(RETRY_DELAY, () -> this.tryToSend(requestContext));
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Request {} failed, will not retry!", (Object)requestContext.hashCode(), (Object)errorOnRequest);
                }
                requestContext.completeExceptionally(errorOnRequest);
            }
        }
    }

    private boolean exceptionShowsConnectionIssue(Throwable throwable) {
        return throwable instanceof ConnectException || throwable instanceof MessagingException.NoRemoteHandler;
    }

    private void timeoutFuture(RequestContext requestContext) {
        if (requestContext.isDone()) {
            return;
        }
        requestContext.timeout();
    }
}

