/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.transport.impl;

import io.atomix.utils.net.Address;
import io.zeebe.transport.impl.AtomixServerTransport;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;

final class RequestContext {
    private final CompletableActorFuture<DirectBuffer> currentFuture;
    private final Supplier<String> nodeAddressSupplier;
    private final int partitionId;
    private final byte[] requestBytes;
    private final boolean shouldRetry;
    private final long startTime;
    private final Duration timeout;
    private final Predicate<DirectBuffer> responseValidator;
    private ScheduledTimer scheduledTimer;

    RequestContext(CompletableActorFuture<DirectBuffer> currentFuture, Supplier<String> nodeAddressSupplier, int partitionId, byte[] requestBytes, Predicate<DirectBuffer> responseValidator, boolean shouldRetry, Duration timeout) {
        this.currentFuture = currentFuture;
        this.nodeAddressSupplier = nodeAddressSupplier;
        this.partitionId = partitionId;
        this.requestBytes = requestBytes;
        this.shouldRetry = shouldRetry;
        this.startTime = ActorClock.currentTimeMillis();
        this.responseValidator = responseValidator;
        this.timeout = timeout;
    }

    public boolean isDone() {
        return this.currentFuture.isDone();
    }

    Address getNodeAddress() {
        String address = this.nodeAddressSupplier.get();
        return address == null ? null : Address.from((String)address);
    }

    String getTopicName() {
        return AtomixServerTransport.topicName(this.partitionId);
    }

    byte[] getRequestBytes() {
        return this.requestBytes;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    Duration calculateTimeout() {
        long currentTime = ActorClock.currentTimeMillis();
        long elapsedTime = currentTime - this.startTime;
        return this.timeout.minus(Duration.ofMillis(elapsedTime));
    }

    boolean verifyResponse(DirectBuffer response) {
        return this.responseValidator.test(response);
    }

    public void complete(DirectBuffer buffer) {
        this.currentFuture.complete((Object)buffer);
        this.cancelTimer();
    }

    public void completeExceptionally(Throwable throwable) {
        this.currentFuture.completeExceptionally(throwable);
        this.cancelTimer();
    }

    private void cancelTimer() {
        if (this.scheduledTimer != null) {
            this.scheduledTimer.cancel();
        }
    }

    public void setScheduledTimer(ScheduledTimer scheduledTimer) {
        this.scheduledTimer = scheduledTimer;
    }

    public void timeout() {
        this.currentFuture.completeExceptionally((Throwable)new TimeoutException("Request timed out after " + this.timeout.toString()));
    }

    public boolean shouldRetry() {
        return this.shouldRetry;
    }
}

