/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.spec;

import java.nio.ByteOrder;

public final class MsgPackCodes {
    public static final byte POSFIXINT_MASK = -128;
    public static final byte FIXMAP_PREFIX = -128;
    public static final byte FIXARRAY_PREFIX = -112;
    public static final byte FIXSTR_PREFIX = -96;
    public static final byte NIL = -64;
    public static final byte NEVER_USED = -63;
    public static final byte FALSE = -62;
    public static final byte TRUE = -61;
    public static final byte BIN8 = -60;
    public static final byte BIN16 = -59;
    public static final byte BIN32 = -58;
    public static final byte EXT8 = -57;
    public static final byte EXT16 = -56;
    public static final byte EXT32 = -55;
    public static final byte FLOAT32 = -54;
    public static final byte FLOAT64 = -53;
    public static final byte UINT8 = -52;
    public static final byte UINT16 = -51;
    public static final byte UINT32 = -50;
    public static final byte UINT64 = -49;
    public static final byte INT8 = -48;
    public static final byte INT16 = -47;
    public static final byte INT32 = -46;
    public static final byte INT64 = -45;
    public static final byte FIXEXT1 = -44;
    public static final byte FIXEXT2 = -43;
    public static final byte FIXEXT4 = -42;
    public static final byte FIXEXT8 = -41;
    public static final byte FIXEXT16 = -40;
    public static final byte STR8 = -39;
    public static final byte STR16 = -38;
    public static final byte STR32 = -37;
    public static final byte ARRAY16 = -36;
    public static final byte ARRAY32 = -35;
    public static final byte MAP16 = -34;
    public static final byte MAP32 = -33;
    public static final byte NEGFIXINT_PREFIX = -32;
    public static final ByteOrder BYTE_ORDER = ByteOrder.BIG_ENDIAN;

    public static boolean isFixInt(byte b) {
        int v = b & 0xFF;
        return v <= 127 || v >= 224;
    }

    public static boolean isPosFixInt(byte b) {
        return (b & 0xFFFFFF80) == 0;
    }

    public static boolean isNegFixInt(byte b) {
        return (b & 0xFFFFFFE0) == -32;
    }

    public static boolean isFixStr(byte b) {
        return (b & 0xFFFFFFE0) == -96;
    }

    public static boolean isFixedArray(byte b) {
        return (b & 0xFFFFFFF0) == -112;
    }

    public static boolean isFixedMap(byte b) {
        return (b & 0xFFFFFFF0) == -128;
    }

    public static boolean isFixedRaw(byte b) {
        return (b & 0xFFFFFFE0) == -96;
    }

    public static boolean isMap(byte b) {
        return MsgPackCodes.isFixedMap(b) || b == -34 || b == -33;
    }
}

