/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.spec;

import io.zeebe.msgpack.spec.MsgPackCodes;
import io.zeebe.msgpack.spec.MsgPackType;

public enum MsgPackFormat {
    POSFIXINT(MsgPackType.INTEGER),
    FIXMAP(MsgPackType.MAP),
    FIXARRAY(MsgPackType.ARRAY),
    FIXSTR(MsgPackType.STRING),
    NIL(MsgPackType.NIL),
    NEVER_USED(MsgPackType.NEVER_USED),
    BOOLEAN(MsgPackType.BOOLEAN),
    BIN8(MsgPackType.BINARY),
    BIN16(MsgPackType.BINARY),
    BIN32(MsgPackType.BINARY),
    EXT8(MsgPackType.EXTENSION),
    EXT16(MsgPackType.EXTENSION),
    EXT32(MsgPackType.EXTENSION),
    FLOAT32(MsgPackType.FLOAT),
    FLOAT64(MsgPackType.FLOAT),
    UINT8(MsgPackType.INTEGER),
    UINT16(MsgPackType.INTEGER),
    UINT32(MsgPackType.INTEGER),
    UINT64(MsgPackType.INTEGER),
    INT8(MsgPackType.INTEGER),
    INT16(MsgPackType.INTEGER),
    INT32(MsgPackType.INTEGER),
    INT64(MsgPackType.INTEGER),
    FIXEXT1(MsgPackType.EXTENSION),
    FIXEXT2(MsgPackType.EXTENSION),
    FIXEXT4(MsgPackType.EXTENSION),
    FIXEXT8(MsgPackType.EXTENSION),
    FIXEXT16(MsgPackType.EXTENSION),
    STR8(MsgPackType.STRING),
    STR16(MsgPackType.STRING),
    STR32(MsgPackType.STRING),
    ARRAY16(MsgPackType.ARRAY),
    ARRAY32(MsgPackType.ARRAY),
    MAP16(MsgPackType.MAP),
    MAP32(MsgPackType.MAP),
    NEGFIXINT(MsgPackType.INTEGER);

    private static final MsgPackFormat[] FORMAT_TABLE;
    protected MsgPackType type;

    private MsgPackFormat(MsgPackType type) {
        this.type = type;
    }

    public MsgPackType getType() {
        return this.type;
    }

    public static MsgPackFormat valueOf(byte b) {
        return FORMAT_TABLE[b & 0xFF];
    }

    static MsgPackFormat toMessageFormat(byte b) {
        if (MsgPackCodes.isPosFixInt(b)) {
            return POSFIXINT;
        }
        if (MsgPackCodes.isNegFixInt(b)) {
            return NEGFIXINT;
        }
        if (MsgPackCodes.isFixStr(b)) {
            return FIXSTR;
        }
        if (MsgPackCodes.isFixedArray(b)) {
            return FIXARRAY;
        }
        if (MsgPackCodes.isFixedMap(b)) {
            return FIXMAP;
        }
        switch (b) {
            case -64: {
                return NIL;
            }
            case -62: 
            case -61: {
                return BOOLEAN;
            }
            case -60: {
                return BIN8;
            }
            case -59: {
                return BIN16;
            }
            case -58: {
                return BIN32;
            }
            case -57: {
                return EXT8;
            }
            case -56: {
                return EXT16;
            }
            case -55: {
                return EXT32;
            }
            case -54: {
                return FLOAT32;
            }
            case -53: {
                return FLOAT64;
            }
            case -52: {
                return UINT8;
            }
            case -51: {
                return UINT16;
            }
            case -50: {
                return UINT32;
            }
            case -49: {
                return UINT64;
            }
            case -48: {
                return INT8;
            }
            case -47: {
                return INT16;
            }
            case -46: {
                return INT32;
            }
            case -45: {
                return INT64;
            }
            case -44: {
                return FIXEXT1;
            }
            case -43: {
                return FIXEXT2;
            }
            case -42: {
                return FIXEXT4;
            }
            case -41: {
                return FIXEXT8;
            }
            case -40: {
                return FIXEXT16;
            }
            case -39: {
                return STR8;
            }
            case -38: {
                return STR16;
            }
            case -37: {
                return STR32;
            }
            case -36: {
                return ARRAY16;
            }
            case -35: {
                return ARRAY32;
            }
            case -34: {
                return MAP16;
            }
            case -33: {
                return MAP32;
            }
        }
        return NEVER_USED;
    }

    static {
        FORMAT_TABLE = new MsgPackFormat[256];
        for (int b = 0; b <= 255; ++b) {
            MsgPackFormat.FORMAT_TABLE[b] = MsgPackFormat.toMessageFormat((byte)b);
        }
    }
}

