/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public final class IncidentMetrics {
    private static final Counter INCIDENT_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("incident_events_total")).help("Number of incident events")).labelNames(new String[]{"action", "partition"})).register();
    private static final Gauge PENDING_INCIDENTS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("pending_incidents_total")).help("Number of pending incidents")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;

    public IncidentMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void incidentEvent(String action) {
        ((Counter.Child)INCIDENT_EVENTS.labels(new String[]{action, this.partitionIdLabel})).inc();
    }

    public void incidentCreated() {
        this.incidentEvent("created");
        ((Gauge.Child)PENDING_INCIDENTS.labels(new String[]{this.partitionIdLabel})).inc();
    }

    public void incidentResolved() {
        this.incidentEvent("resolved");
        ((Gauge.Child)PENDING_INCIDENTS.labels(new String[]{this.partitionIdLabel})).dec();
    }
}

