/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.zeebe.protocol.record.value.BpmnElementType;

public final class ProcessEngineMetrics {
    private static final Counter ELEMENT_INSTANCE_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("element_instance_events_total")).help("Number of process element instance events")).labelNames(new String[]{"action", "type", "partition"})).register();
    private static final Gauge RUNNING_PROCESS_INSTANCES = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("running_process_instances_total")).help("Number of running process instances")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;

    public ProcessEngineMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void elementInstanceEvent(String action, BpmnElementType elementType) {
        ((Counter.Child)ELEMENT_INSTANCE_EVENTS.labels(new String[]{action, elementType.name(), this.partitionIdLabel})).inc();
    }

    private void processInstanceCreated() {
        ((Gauge.Child)RUNNING_PROCESS_INSTANCES.labels(new String[]{this.partitionIdLabel})).inc();
    }

    private void processInstanceFinished() {
        ((Gauge.Child)RUNNING_PROCESS_INSTANCES.labels(new String[]{this.partitionIdLabel})).dec();
    }

    public void elementInstanceActivated(BpmnElementType elementType) {
        this.elementInstanceEvent("activated", elementType);
        if (this.isProcessInstance(elementType)) {
            this.processInstanceCreated();
        }
    }

    public void elementInstanceCompleted(BpmnElementType elementType) {
        this.elementInstanceEvent("completed", elementType);
        if (this.isProcessInstance(elementType)) {
            this.processInstanceFinished();
        }
    }

    public void elementInstanceTerminated(BpmnElementType elementType) {
        this.elementInstanceEvent("terminated", elementType);
        if (this.isProcessInstance(elementType)) {
            this.processInstanceFinished();
        }
    }

    private boolean isProcessInstance(BpmnElementType elementType) {
        return BpmnElementType.PROCESS == elementType;
    }
}

