/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.zeebe.protocol.record.RecordType;

public final class StreamProcessorMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final Counter STREAM_PROCESSOR_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("stream_processor_events_total")).help("Number of events processed by stream processor")).labelNames(new String[]{"action", "partition"})).register();
    private static final Gauge LAST_PROCESSED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("stream_processor_last_processed_position")).help("The last position the stream processor has processed.")).labelNames(new String[]{"partition"})).register();
    private static final Histogram PROCESSING_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_latency")).help("Time between a record is written until it is picked up for processing (in seconds)")).labelNames(new String[]{"recordType", "partition"})).register();
    private static final Histogram PROCESSING_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_processing_duration")).help("Time for processing a record (in seconds)")).labelNames(new String[]{"recordType", "partition"})).register();
    private static final Gauge STARTUP_RECOVERY_TIME = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("stream_processor_startup_recovery_time")).help("Time taken for startup and recovery of stream processor (in ms)")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;

    public StreamProcessorMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void event(String action) {
        ((Counter.Child)STREAM_PROCESSOR_EVENTS.labels(new String[]{action, this.partitionIdLabel})).inc();
    }

    public void processingLatency(RecordType recordType, long written, long processed) {
        ((Histogram.Child)PROCESSING_LATENCY.labels(new String[]{recordType.name(), this.partitionIdLabel})).observe((double)((float)(processed - written) / 1000.0f));
    }

    public void processingDuration(RecordType recordType, long started, long processed) {
        ((Histogram.Child)PROCESSING_DURATION.labels(new String[]{recordType.name(), this.partitionIdLabel})).observe((double)((float)(processed - started) / 1000.0f));
    }

    public void eventProcessed() {
        this.event("processed");
    }

    public void eventWritten() {
        this.event("written");
    }

    public void eventSkipped() {
        this.event("skipped");
    }

    public void recoveryTime(long durationMillis) {
        ((Gauge.Child)STARTUP_RECOVERY_TIME.labels(new String[]{this.partitionIdLabel})).set((double)durationMillis);
    }

    public void setLastProcessedPosition(long position) {
        ((Gauge.Child)LAST_PROCESSED_POSITION.labels(new String[]{this.partitionIdLabel})).set((double)position);
    }
}

