/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing;

import io.zeebe.el.ExpressionLanguageFactory;
import io.zeebe.engine.processing.ProcessEventProcessors;
import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.zeebe.engine.processing.deployment.DeploymentResponder;
import io.zeebe.engine.processing.deployment.distribute.CompleteDeploymentDistributionProcessor;
import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.zeebe.engine.processing.job.JobEventProcessors;
import io.zeebe.engine.processing.message.MessageEventProcessors;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.ZeebeState;
import io.zeebe.engine.state.mutable.MutableVariableState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.util.sched.ActorControl;
import java.util.function.Consumer;

public final class EngineProcessors {
    public static TypedRecordProcessors createEngineProcessors(ProcessingContext processingContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, DeploymentDistributor deploymentDistributor, DeploymentResponder deploymentResponder, Consumer<String> onJobsAvailableCallback) {
        ActorControl actor = processingContext.getActor();
        MutableZeebeState zeebeState = processingContext.getZeebeState();
        Writers writers = processingContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(zeebeState.getKeyGenerator(), writers);
        LogStream stream = processingContext.getLogStream();
        int partitionId = stream.getPartitionId();
        int maxFragmentSize = processingContext.getMaxFragmentSize();
        MutableVariableState variablesState = zeebeState.getVariableState();
        ExpressionProcessor expressionProcessor = new ExpressionProcessor(ExpressionLanguageFactory.createExpressionLanguage(), variablesState::getVariable);
        CatchEventBehavior catchEventBehavior = new CatchEventBehavior(zeebeState, expressionProcessor, subscriptionCommandSender, writers.state(), partitionsCount);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(catchEventBehavior, partitionId, zeebeState, typedRecordProcessors, deploymentResponder, expressionProcessor, writers, partitionsCount, actor, deploymentDistributor, zeebeState.getKeyGenerator());
        EngineProcessors.addMessageProcessors(subscriptionCommandSender, zeebeState, typedRecordProcessors, writers);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(zeebeState, expressionProcessor, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior, writers);
        EngineProcessors.addJobProcessors(zeebeState, typedRecordProcessors, onJobsAvailableCallback, maxFragmentSize, writers);
        EngineProcessors.addIncidentProcessors(zeebeState, bpmnStreamProcessor, typedRecordProcessors, writers);
        return typedRecordProcessors;
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, ExpressionProcessor expressionProcessor, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior, Writers writers) {
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(zeebeState.getTimerState());
        return ProcessEventProcessors.addProcessProcessors(zeebeState, expressionProcessor, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior, timerChecker, writers);
    }

    private static void addDeploymentRelatedProcessorAndServices(CatchEventBehavior catchEventBehavior, int partitionId, ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, DeploymentResponder deploymentResponder, ExpressionProcessor expressionProcessor, Writers writers, int partitionsCount, ActorControl actor, DeploymentDistributor deploymentDistributor, KeyGenerator keyGenerator) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(zeebeState, catchEventBehavior, expressionProcessor, partitionsCount, writers, actor, deploymentDistributor, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(partitionsCount, deploymentDistributor, zeebeState.getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(zeebeState.getProcessState(), deploymentResponder, partitionId, writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        CompleteDeploymentDistributionProcessor completeDeploymentDistributionProcessor = new CompleteDeploymentDistributionProcessor(zeebeState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(MutableZeebeState zeebeState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, zeebeState, bpmnStreamProcessor, writers);
    }

    private static void addJobProcessors(MutableZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, Consumer<String> onJobsAvailableCallback, int maxFragmentSize, Writers writers) {
        JobEventProcessors.addJobProcessors(typedRecordProcessors, zeebeState, onJobsAvailableCallback, maxFragmentSize, writers);
    }

    private static void addMessageProcessors(SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        MessageEventProcessors.addMessageProcessors(typedRecordProcessors, zeebeState, subscriptionCommandSender, writers);
    }
}

