/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing;

import io.zeebe.engine.processing.bpmn.BpmnStreamProcessor;
import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.message.CorrelateProcessInstanceSubscription;
import io.zeebe.engine.processing.message.ProcessInstanceSubscriptionCreateProcessor;
import io.zeebe.engine.processing.message.ProcessInstanceSubscriptionDeleteProcessor;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.processinstance.CreateProcessInstanceProcessor;
import io.zeebe.engine.processing.processinstance.CreateProcessInstanceWithResultProcessor;
import io.zeebe.engine.processing.processinstance.ProcessInstanceCommandProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.processing.timer.CancelTimerProcessor;
import io.zeebe.engine.processing.timer.CreateTimerProcessor;
import io.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.zeebe.engine.processing.timer.TriggerTimerProcessor;
import io.zeebe.engine.processing.variable.UpdateVariableDocumentProcessor;
import io.zeebe.engine.processing.variable.VariableBehavior;
import io.zeebe.engine.state.KeyGenerator;
import io.zeebe.engine.state.immutable.ElementInstanceState;
import io.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.zeebe.engine.state.mutable.MutableProcessInstanceSubscriptionState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.intent.ProcessInstanceSubscriptionIntent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import java.util.Arrays;

public final class ProcessEventProcessors {
    public static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, ExpressionProcessor expressionProcessor, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior, DueDateTimerChecker timerChecker, Writers writers) {
        MutableProcessInstanceSubscriptionState subscriptionState = zeebeState.getProcessInstanceSubscriptionState();
        VariableBehavior variableBehavior = new VariableBehavior(zeebeState.getVariableState(), writers.state(), zeebeState.getKeyGenerator());
        ProcessEventProcessors.addProcessInstanceCommandProcessor(typedRecordProcessors, zeebeState.getElementInstanceState());
        BpmnStreamProcessor bpmnStreamProcessor = new BpmnStreamProcessor(expressionProcessor, catchEventBehavior, variableBehavior, zeebeState, writers);
        ProcessEventProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStreamProcessor);
        ProcessEventProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, zeebeState, writers);
        ProcessEventProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, zeebeState, catchEventBehavior, expressionProcessor);
        ProcessEventProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, variableBehavior, zeebeState.getElementInstanceState(), zeebeState.getKeyGenerator(), writers.state());
        ProcessEventProcessors.addProcessInstanceCreationStreamProcessors(typedRecordProcessors, zeebeState, writers, variableBehavior);
        return bpmnStreamProcessor;
    }

    private static void addProcessInstanceCommandProcessor(TypedRecordProcessors typedRecordProcessors, MutableElementInstanceState elementInstanceState) {
        ProcessInstanceCommandProcessor commandProcessor = new ProcessInstanceCommandProcessor(elementInstanceState);
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isProcessInstanceCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, commandProcessor));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStreamProcessor bpmnStepProcessor) {
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementEvent).forEach(intent -> typedRecordProcessors.onEvent(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessInstanceSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.CREATE, new ProcessInstanceSubscriptionCreateProcessor(zeebeState.getProcessInstanceSubscriptionState(), writers)).onCommand(ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.CORRELATE, new CorrelateProcessInstanceSubscription(subscriptionState, subscriptionCommandSender, zeebeState)).onCommand(ValueType.PROCESS_INSTANCE_SUBSCRIPTION, (Intent)ProcessInstanceSubscriptionIntent.DELETE, new ProcessInstanceSubscriptionDeleteProcessor(subscriptionState, writers));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, MutableZeebeState zeebeState, CatchEventBehavior catchEventOutput, ExpressionProcessor expressionProcessor) {
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.CREATE, new CreateTimerProcessor(zeebeState, timerChecker)).onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TriggerTimerProcessor(zeebeState, catchEventOutput, expressionProcessor)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new CancelTimerProcessor(zeebeState.getTimerState())).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, VariableBehavior variableBehavior, ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, StateWriter stateWriter) {
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new UpdateVariableDocumentProcessor(elementInstanceState, keyGenerator, variableBehavior, stateWriter));
    }

    private static void addProcessInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, Writers writers, VariableBehavior variableBehavior) {
        MutableElementInstanceState elementInstanceState = zeebeState.getElementInstanceState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        CreateProcessInstanceProcessor createProcessor = new CreateProcessInstanceProcessor(zeebeState.getProcessState(), elementInstanceState, keyGenerator, writers, variableBehavior);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, createProcessor);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, new CreateProcessInstanceWithResultProcessor(createProcessor, elementInstanceState));
    }
}

