/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.zeebe.engine.processing.bpmn.BpmnElementProcessors;
import io.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.zeebe.engine.processing.bpmn.behavior.TypedResponseWriterProxy;
import io.zeebe.engine.processing.bpmn.behavior.TypedStreamWriterProxy;
import io.zeebe.engine.processing.common.CatchEventBehavior;
import io.zeebe.engine.processing.common.ExpressionProcessor;
import io.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.zeebe.engine.processing.variable.VariableBehavior;
import io.zeebe.engine.state.immutable.ProcessState;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BpmnStreamProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private static final Logger LOGGER = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final TypedStreamWriterProxy streamWriterProxy = new TypedStreamWriterProxy();
    private final TypedResponseWriterProxy responseWriterProxy = new TypedResponseWriterProxy();
    private final SideEffectQueue sideEffectQueue = new SideEffectQueue();
    private final BpmnElementContextImpl context = new BpmnElementContextImpl();
    private final ProcessState processState;
    private final BpmnElementProcessors processors;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;

    public BpmnStreamProcessor(ExpressionProcessor expressionProcessor, CatchEventBehavior catchEventBehavior, VariableBehavior variableBehavior, MutableZeebeState zeebeState, Writers writers) {
        this.processState = zeebeState.getProcessState();
        BpmnBehaviorsImpl bpmnBehaviors = new BpmnBehaviorsImpl(expressionProcessor, this.streamWriterProxy, this.responseWriterProxy, this.sideEffectQueue, zeebeState, catchEventBehavior, variableBehavior, this::getContainerProcessor, writers);
        this.processors = new BpmnElementProcessors(bpmnBehaviors);
        this.stateTransitionGuard = bpmnBehaviors.stateTransitionGuard();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
    }

    private BpmnElementContainerProcessor<ExecutableFlowElement> getContainerProcessor(BpmnElementType elementType) {
        return this.processors.getContainerProcessor(elementType);
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.streamWriterProxy.wrap(streamWriter);
        this.responseWriterProxy.wrap(responseWriter, writer -> this.sideEffectQueue.add(writer::flush));
        this.sideEffectQueue.clear();
        sideEffect.accept(this.sideEffectQueue);
        ProcessInstanceIntent intent = (ProcessInstanceIntent)record.getIntent();
        ProcessInstanceRecord recordValue = record.getValue();
        this.context.init(record.getKey(), recordValue, intent);
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        BpmnElementProcessor<ExecutableFlowElement> processor = this.processors.getProcessor(bpmnElementType);
        ExecutableFlowElement element = this.getElement(recordValue, processor);
        if (this.stateTransitionGuard.isValidStateTransition(this.context)) {
            LOGGER.trace("Process process instance event [context: {}]", (Object)this.context);
            this.processEvent(intent, processor, element);
        }
    }

    private void processEvent(ProcessInstanceIntent intent, BpmnElementProcessor<ExecutableFlowElement> processor, ExecutableFlowElement element) {
        switch (intent) {
            case ACTIVATE_ELEMENT: {
                if (MigratedStreamProcessors.isMigrated(this.context.getBpmnElementType())) {
                    BpmnElementContext activatingContext = this.stateTransitionBehavior.transitionToActivating(this.context);
                    processor.onActivate(element, activatingContext);
                    break;
                }
                processor.onActivating(element, this.context);
                break;
            }
            case COMPLETE_ELEMENT: {
                if (MigratedStreamProcessors.isMigrated(this.context.getBpmnElementType())) {
                    BpmnElementContext completingContext = this.stateTransitionBehavior.transitionToCompleting(this.context);
                    processor.onComplete(element, completingContext);
                    break;
                }
                processor.onCompleting(element, this.context);
                break;
            }
            case TERMINATE_ELEMENT: {
                if (MigratedStreamProcessors.isMigrated(this.context.getBpmnElementType())) {
                    BpmnElementContext terminatingContext = this.stateTransitionBehavior.transitionToTerminating(this.context);
                    processor.onTerminate(element, terminatingContext);
                    break;
                }
                processor.onTerminating(element, this.context);
                break;
            }
            case ELEMENT_ACTIVATING: {
                processor.onActivating(element, this.context);
                break;
            }
            case ELEMENT_ACTIVATED: {
                processor.onActivated(element, this.context);
                break;
            }
            case EVENT_OCCURRED: {
                processor.onEventOccurred(element, this.context);
                break;
            }
            case ELEMENT_COMPLETING: {
                processor.onCompleting(element, this.context);
                break;
            }
            case ELEMENT_COMPLETED: {
                processor.onCompleted(element, this.context);
                break;
            }
            case ELEMENT_TERMINATING: {
                processor.onTerminating(element, this.context);
                break;
            }
            case ELEMENT_TERMINATED: {
                processor.onTerminated(element, this.context);
                break;
            }
            case SEQUENCE_FLOW_TAKEN: {
                processor.onActivating(element, this.context);
                break;
            }
            default: {
                throw new BpmnProcessingException(this.context, String.format("Expected the processor '%s' to handle the event but the intent '%s' is not supported", processor.getClass(), intent));
            }
        }
    }

    private ExecutableFlowElement getElement(ProcessInstanceRecord recordValue, BpmnElementProcessor<ExecutableFlowElement> processor) {
        return this.processState.getFlowElement(recordValue.getProcessDefinitionKey(), recordValue.getElementIdBuffer(), processor.getType());
    }
}

