/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn;

import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class ProcessInstanceLifecycle {
    private static final EnumSet<ProcessInstanceIntent> ELEMENT_INSTANCE_STATES = EnumSet.of(ProcessInstanceIntent.ELEMENT_ACTIVATING, new ProcessInstanceIntent[]{ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATING, ProcessInstanceIntent.ELEMENT_TERMINATED});
    private static final EnumSet<ProcessInstanceIntent> FINAL_ELEMENT_INSTANCE_STATES = EnumSet.of(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATED);
    private static final EnumSet<ProcessInstanceIntent> TERMINATABLE_STATES = EnumSet.of(ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING);
    private static final Map<ProcessInstanceIntent, Set<ProcessInstanceIntent>> TRANSITION_RULES = new EnumMap<ProcessInstanceIntent, Set<ProcessInstanceIntent>>(ProcessInstanceIntent.class);

    private ProcessInstanceLifecycle() {
    }

    public static boolean canTransition(ProcessInstanceIntent from, ProcessInstanceIntent to) {
        return TRANSITION_RULES.get(from).contains(to);
    }

    public static boolean isFinalState(ProcessInstanceIntent state) {
        return FINAL_ELEMENT_INSTANCE_STATES.contains(state);
    }

    public static boolean isInitialState(ProcessInstanceIntent state) {
        return state == ProcessInstanceIntent.ELEMENT_ACTIVATING;
    }

    public static boolean isElementInstanceState(ProcessInstanceIntent state) {
        return ELEMENT_INSTANCE_STATES.contains(state);
    }

    public static boolean isTokenState(ProcessInstanceIntent state) {
        return !ProcessInstanceLifecycle.isElementInstanceState(state);
    }

    public static boolean canTerminate(ProcessInstanceIntent currentState) {
        return TERMINATABLE_STATES.contains(currentState);
    }

    public static boolean isActive(ProcessInstanceIntent currentState) {
        return currentState == ProcessInstanceIntent.ELEMENT_ACTIVATED;
    }

    public static boolean isTerminating(ProcessInstanceIntent currentState) {
        return currentState == ProcessInstanceIntent.ELEMENT_TERMINATING;
    }

    static {
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_ACTIVATING, EnumSet.of(ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_ACTIVATED, EnumSet.of(ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_COMPLETING, EnumSet.of(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_TERMINATING, EnumSet.of(ProcessInstanceIntent.ELEMENT_TERMINATED));
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_COMPLETED, EnumSet.of(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN));
        TRANSITION_RULES.put(ProcessInstanceIntent.ELEMENT_TERMINATED, Collections.emptySet());
        TRANSITION_RULES.put(ProcessInstanceIntent.EVENT_OCCURRED, EnumSet.of(ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_TERMINATING));
        TRANSITION_RULES.put(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, EnumSet.of(ProcessInstanceIntent.ELEMENT_ACTIVATING));
    }
}

