/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processing.bpmn;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.Either;
import java.util.Arrays;
import org.slf4j.Logger;

public final class ProcessInstanceStateTransitionGuard {
    private static final Logger LOGGER = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final BpmnStateBehavior stateBehavior;

    public ProcessInstanceStateTransitionGuard(BpmnStateBehavior stateBehavior) {
        this.stateBehavior = stateBehavior;
    }

    public boolean isValidStateTransition(BpmnElementContext context) {
        Either<String, ?> result = this.checkStateTransition(context);
        result.ifLeft(violation -> LOGGER.debug("Don't process event because of an illegal state transition: {} [context: {}]", violation, (Object)context));
        return result.isRight();
    }

    private Either<String, ?> checkStateTransition(BpmnElementContext context) {
        switch (context.getIntent()) {
            case ACTIVATE_ELEMENT: {
                return Either.right(null);
            }
            case COMPLETE_ELEMENT: {
                return this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceIntent[0]).flatMap(ok -> this.hasActiveFlowScopeInstance(context));
            }
            case TERMINATE_ELEMENT: {
                return this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING);
            }
            case ELEMENT_ACTIVATING: 
            case ELEMENT_ACTIVATED: 
            case ELEMENT_COMPLETING: 
            case ELEMENT_COMPLETED: {
                return this.hasElementInstanceWithState(context, context.getIntent(), new ProcessInstanceIntent[0]).flatMap(ok -> this.hasActiveFlowScopeInstance(context));
            }
            case ELEMENT_TERMINATING: 
            case ELEMENT_TERMINATED: {
                return this.hasElementInstanceWithState(context, context.getIntent(), new ProcessInstanceIntent[0]);
            }
            case EVENT_OCCURRED: {
                if (context.getBpmnElementType() == BpmnElementType.START_EVENT) {
                    return Either.right(null);
                }
                return this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceIntent[0]);
            }
            case SEQUENCE_FLOW_TAKEN: {
                return this.hasActiveFlowScopeInstance(context);
            }
        }
        return Either.left((Object)String.format("Expected event to have a process instance intent but was '%s'", context.getIntent()));
    }

    private Either<String, ElementInstance> getElementInstance(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (elementInstance != null) {
            return Either.right((Object)((Object)elementInstance));
        }
        return Either.left((Object)String.format("Expected element instance with key '%d' to be present in state but not found.", context.getElementInstanceKey()));
    }

    private Either<String, ElementInstance> getFlowScopeInstance(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        if (flowScopeInstance != null) {
            return Either.right((Object)((Object)flowScopeInstance));
        }
        return Either.left((Object)String.format("Expected flow scope instance with key '%d' to be present in state but not found.", context.getElementInstanceKey()));
    }

    private Either<String, ElementInstance> hasElementInstanceInState(ElementInstance elementInstance, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        ProcessInstanceIntent currentState = elementInstance.getState();
        if (expectedState != currentState && !Arrays.asList(otherExpected).contains(currentState)) {
            return Either.left((Object)String.format("Expected element instance to be in state '%s' or one of '%s' but was '%s'.", expectedState, Arrays.toString(otherExpected), currentState));
        }
        return Either.right((Object)((Object)elementInstance));
    }

    private Either<String, ?> hasElementInstanceWithState(BpmnElementContext context, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        return this.getElementInstance(context).flatMap(elementInstance -> this.hasElementInstanceInState((ElementInstance)((Object)elementInstance), expectedState, otherExpected));
    }

    private Either<String, ElementInstance> hasFlowScopeInstanceInState(ElementInstance flowScopeInstance, ProcessInstanceIntent expectedState) {
        ProcessInstanceIntent currentState = flowScopeInstance.getState();
        if (currentState != expectedState) {
            return Either.left((Object)String.format("Expected flow scope instance to be in state '%s' but was '%s'.", expectedState, currentState));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ElementInstance> hasNonInterruptedFlowScope(ElementInstance flowScopeInstance, BpmnElementContext context) {
        long interruptingEventKey = flowScopeInstance.getInterruptingEventKey();
        if (interruptingEventKey > 0L && interruptingEventKey != context.getElementInstanceKey()) {
            return Either.left((Object)String.format("Expected flow scope instance to be not interrupted but was interrupted by an event with key '%d'.", interruptingEventKey));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ?> hasActiveFlowScopeInstance(BpmnElementContext context) {
        if (context.getBpmnElementType() == BpmnElementType.PROCESS) {
            return Either.right(null);
        }
        return this.getFlowScopeInstance(context).flatMap(flowScopeInstance -> this.hasFlowScopeInstanceInState((ElementInstance)((Object)flowScopeInstance), ProcessInstanceIntent.ELEMENT_ACTIVATED)).flatMap(flowScopeInstance -> this.hasNonInterruptedFlowScope((ElementInstance)((Object)flowScopeInstance), context));
    }

    public void registerStateTransition(BpmnElementContext context, ProcessInstanceIntent newState) {
        switch (newState) {
            case ELEMENT_ACTIVATING: 
            case ELEMENT_ACTIVATED: 
            case ELEMENT_COMPLETING: 
            case ELEMENT_COMPLETED: 
            case ELEMENT_TERMINATING: 
            case ELEMENT_TERMINATED: {
                this.updateElementInstanceState(context, newState);
                break;
            }
        }
    }

    private void updateElementInstanceState(BpmnElementContext context, ProcessInstanceIntent newState) {
        this.stateBehavior.updateElementInstance(context, elementInstance -> elementInstance.setState(newState));
    }
}

